package ai.systema.configuration.internal

import ai.systema.configuration.*
import ai.systema.configuration.internal.extension.getHttpClient
import ai.systema.enums.EndpointType
import ai.systema.helper.logging.SystemaLogLevel
import io.ktor.client.*
import io.ktor.client.engine.*

internal class ConfigurationImpl(
    override val credentials: Credentials,
    override val writeTimeout: Long,
    override val readTimeout: Long,
    override val logLevel: SystemaLogLevel,
    override val hosts: Map<EndpointType, List<RetryableHost>>,
    override val defaultHeaders: Map<String, String>?,
    override val engine: HttpClientEngine?,
    override val httpClientConfig: (HttpClientConfig<*>.() -> Unit)?,
    override val compression: Compression,
    override val kvStore: SystemaKVStore,
) : Configuration {
    override val httpClient: HttpClient = getHttpClient()
}