package ai.systema.helper

import ai.systema.model.APIKey
import ai.systema.model.Attribute
import ai.systema.model.ClientID

/**
 * Convenience method to convert [this] to an [Attribute].
 */
public fun String.toAttribute(): Attribute {
    return Attribute(this)
}

/**
 * Convenience method to convert [this] to an [ClientID].
 */
public fun String.toClientID(): ClientID {
    return ClientID(this)
}

/**
 * Convenience method to convert [this] to an [APIKey].
 */
public fun String.toAPIKey(): APIKey {
    return APIKey(this)
}