package ai.systema.model

import ai.systema.constants.SystemaConstants
import ai.systema.exception.EmptyStringException
import ai.systema.model.internal.Raw

public data class ClientID(override val raw: String) : Raw<String> {

    init {
        if (raw.isBlank()) throw EmptyStringException("ClientID")
        if (raw.length > SystemaConstants.MaxKeyLen) throw IllegalArgumentException("ClientID is too long")
    }

    override fun toString(): String {
        return raw
    }
}
