package ai.systema.model.index

import ai.systema.serialize.Keys
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonElement

@Serializable
public data class Product(
    @SerialName(Keys.Id) val id: String,
    @SerialName(Keys.Brand) val brand: String? = null,
    @SerialName(Keys.Currency) val currency: String? = null,
    @SerialName(Keys.Description) val description: String? = null,
    @SerialName(Keys.Image) val image: String,
    @SerialName(Keys.Images) val images: List<String>? = null,
    @SerialName(Keys.InStock) val inStock: Boolean? = null,
    @SerialName(Keys.ItemGroupId) val itemGroupId: String? = null,
    @SerialName(Keys.Link) val link: String,
    @SerialName(Keys.Price) val price: Double? = null,
    @SerialName(Keys.Promotion) val promotion: String? = null,
    @SerialName(Keys.SalePrice) val salePrice: Float? = null,
    @SerialName(Keys.Title) val title: String,
    @SerialName(Keys.RecId) val recId: String,
    @SerialName(Keys.Tags) val tags: List<String>? = null,
    @SerialName(Keys.Attributes) val attributes: Map<String, JsonElement>? = null,
)
