package ai.systema.model.response

import ai.systema.model.index.Product
import ai.systema.serialize.Keys
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonElement

@Serializable
public data class SmartSearchResponse(
    @SerialName(Keys.Results) val results: List<Product>,
    @SerialName(Keys.Size) val size: Int,
    @SerialName(Keys.Total) val total: Int,
    @SerialName(Keys.Facets) val facets: Map<String, JsonElement>? = mapOf(), // Array of Double | Boolean| FacetInsight
    @SerialName(Keys.Time) val time: String,
    @SerialName(Keys.PaginationTimestamp) val paginationTimestamp: Long,
    @SerialName(Keys.ResultId) val resultId: String,
)
