package ai.systema

import ai.systema.configuration.Configuration
import ai.systema.configuration.Credentials
import ai.systema.configuration.internal.SystemaInMemStorage
import ai.systema.connection.internal.Connector
import ai.systema.connection.internal.hosts
import ai.systema.enums.EndpointType
import ai.systema.enums.EnvironmentType
import ai.systema.helper.logging.SystemaLogLevel
import ai.systema.model.APIKey
import ai.systema.model.ClientID
import io.ktor.http.Url

internal object TestConfig {
    private val kvStore = SystemaInMemStorage()
    private val proxyUrl = Url("https://daef600f-b1c2-49fc-a739-c56ad0c74ca1.mock.pstmn.io")

    private val credentials = Credentials(
        clientID = ClientID("unreal"),
        apiKey = APIKey("PMAK-6113bbd984433f0046e30785-fe032bc85b42f8e1eff7507f1c23d592b9"),
        environment = EnvironmentType.TEST,
        proxyUrls = mapOf(
            EndpointType.DynamicConfig to proxyUrl,
            EndpointType.Tracker to proxyUrl,
            EndpointType.Recommend to proxyUrl
        )
    )

    val configuration = Configuration(
        credentials = credentials,
        hosts = credentials.hosts,
        logLevel = SystemaLogLevel.DEBUG,
        kvStore = kvStore
    )

    private val connector = Connector(configuration)
    private var hasInitialized: Boolean = false
    suspend fun getConnector(): Connector {
        if (!hasInitialized) {
            connector.initialize()
            hasInitialized = true
        }
        return connector
    }
}
