package ai.systema.client.internal

import ai.systema.TestConfig
import ai.systema.endpoint.EndpointTracker
import ai.systema.helper.logging.SystemaLoggerFactory
import ai.systema.model.tracker.cart.CartItem
import ai.systema.model.tracker.cart.OrderItem
import ai.systema.model.tracker.cart.PurchaseOrder
import ai.systema.model.tracker.wishlist.WishlistItem
import ai.systema.testSuspend
import io.ktor.http.HttpStatusCode
import kotlin.test.Ignore
import kotlin.test.Test
import kotlin.test.assertEquals


internal class TrackerImplTest {
    private val logger = SystemaLoggerFactory.logger(TrackerImplTest::class.toString())

    @Test
    fun testTrackPageViewed() {
    }

    @Test
    fun testTrackItemClicked() {
    }

    @Test
    fun testTrackContainerShown() {
    }

    @Test
    @Ignore
    fun testTrackCartEvents() = testSuspend {
        val connector = TestConfig.getConnector()
        val tracker = TrackerImpl(connector, EndpointTracker(connector))
        val items: List<CartItem> = listOf(
            CartItem(itemId = "24-MB02", quantity = 1),
            CartItem(itemId = "24-MB05", quantity = 1),
        )
        var resp = tracker.trackItemAcquired(items, "https://sdk-test.systema.ai/cart")
        assertEquals(HttpStatusCode.NoContent, resp.status)

        resp = tracker.trackItemAcquired(listOf(items[0]), "https://sdk-test.systema.ai/cart")
        assertEquals(HttpStatusCode.NoContent, resp.status)

        resp = tracker.trackItemRelinquished(items[0], "https://sdk-test.systema.ai/cart")
        assertEquals(HttpStatusCode.NoContent, resp.status)

        val orderItems: List<OrderItem> = listOf(
            OrderItem(itemId = "24-MB02", quantity = 1, unitCost = 10.0),
            OrderItem(itemId = "24-MB05", quantity = 1, unitCost = 15.99),
        )
        val order = PurchaseOrder(
            orderId = "test-order-id",
            chargedAmount = 100.00,
            totalAmount = 110.00,
            taxAmount = 0.00,
            shippingAmount = 10.00,
            discountAmount = 0.00,
            items = orderItems,
        )
        resp = tracker.trackAcquisitionComplete(order, "https://sdk-test.systema.ai/cart")
        assertEquals(HttpStatusCode.NoContent, resp.status)
    }

    @Test
    @Ignore
    fun testTrackWishlistEvents() = testSuspend {
        val connector = TestConfig.getConnector()
        val tracker = TrackerImpl(connector, EndpointTracker(connector))
        val items: List<WishlistItem> = listOf(
            WishlistItem(itemId = "24-MB02"),
            WishlistItem(itemId = "24-MB05"),
        )
        var resp = tracker.trackWishlistAcquired(items, "https://sdk-test.systema.ai/wishlist")
        assertEquals(HttpStatusCode.NoContent, resp.status)

        resp = tracker.trackWishlistRelinquished(items[0], "https://sdk-test.systema.ai/wishlist")
        assertEquals(HttpStatusCode.NoContent, resp.status)
    }
}