import ai.systema.TestConfig
import ai.systema.connection.internal.Connector
import ai.systema.endpoint.internal.EndpointRecommendationImpl
import ai.systema.model.request.RecommendationRequest
import ai.systema.model.response.RecommendationResponse
import ai.systema.testSuspend
import kotlin.test.*

internal class EndpointRecommendationImplTest {
    private val connector = Connector(TestConfig.configuration)
    private val ep = EndpointRecommendationImpl(connector)

    @Test
    @Ignore
    fun testGetRelated() = testSuspend {
        assertFailsWith<IllegalArgumentException> {
            val payload = RecommendationRequest(
                environment = connector.credentials.environment.value,
                user = connector.clientUser.toRequestUser(),
                id = ""
            )

            ep.getRelated(payload)
        }

        var payload = RecommendationRequest(
            environment = connector.credentials.environment.value,
            user = connector.clientUser.toRequestUser(),
            id = "WSH10_White"
        )
        var resp = ep.getRelated(payload)
        assertNotEquals(0, resp.results.size)
    }

    @Test
    @Ignore
    fun testGetComplimentary() = testSuspend {
        assertFailsWith<IllegalArgumentException> {
            val payload = RecommendationRequest(
                environment = connector.credentials.environment.value,
                user = connector.clientUser.toRequestUser(),
                id = ""
            )

            ep.getComplementary(payload)
        }

        var payload = RecommendationRequest(
            environment = connector.credentials.environment.value,
            user = connector.clientUser.toRequestUser(),
            id = "WSH10_White"
        )
        var resp = ep.getComplementary(payload)
        assertNotEquals(0, resp.results.size)
        checkResponse(resp)
    }

    @Test
    @Ignore
    fun testGetSimilar() = testSuspend {
        assertFailsWith<IllegalArgumentException> {
            val payload = RecommendationRequest(
                environment = connector.credentials.environment.value,
                user = connector.clientUser.toRequestUser(),
                id = ""
            )

            ep.getSimilar(payload)
        }

        var payload = RecommendationRequest(
            environment = connector.credentials.environment.value,
            user = connector.clientUser.toRequestUser(),
            id = "WSH10_White"
        )
        var resp = ep.getSimilar(payload)
        assertNotEquals(0, resp.results.size)
        checkResponse(resp)
    }

    @Test
    @Ignore
    fun testGetCategoryTrending() = testSuspend {
        // no category will error
        assertFailsWith<IllegalArgumentException> {
            val payload = RecommendationRequest(
                environment = connector.credentials.environment.value,
                user = connector.clientUser.toRequestUser(),
            )

            ep.getCategoryTrending(payload)
        }

        // non-null id will error
        assertFailsWith<IllegalArgumentException> {
            val payload = RecommendationRequest(
                environment = connector.credentials.environment.value,
                user = connector.clientUser.toRequestUser(),
                id = "",
                category = listOf("Men"),
            )

            ep.getCategoryTrending(payload)
        }

        var payload = RecommendationRequest(
            environment = connector.credentials.environment.value,
            user = connector.clientUser.toRequestUser(),
            category = listOf("Men"),
        )
        var resp = ep.getCategoryTrending(payload)
        assertNotEquals(0, resp.results.size)
        checkResponse(resp)
    }

    @Test
    @Ignore
    fun testGetCategoryPopular() = testSuspend {
        // no category will error
        assertFailsWith<IllegalArgumentException> {
            val payload = RecommendationRequest(
                environment = connector.credentials.environment.value,
                user = connector.clientUser.toRequestUser(),
            )

            ep.getCategoryPopular(payload)
        }

        // non-null id will error
        assertFailsWith<IllegalArgumentException> {
            val payload = RecommendationRequest(
                environment = connector.credentials.environment.value,
                user = connector.clientUser.toRequestUser(),
                id = "",
                category = listOf("Men"),
            )

            ep.getCategoryPopular(payload)
        }

        var payload = RecommendationRequest(
            environment = connector.credentials.environment.value,
            user = connector.clientUser.toRequestUser(),
            category = listOf("Men"),
        )
        var resp = ep.getCategoryPopular(payload)
        assertNotEquals(0, resp.results.size)
        checkResponse(resp)
    }

    @Test
    @Ignore
    fun testGetPopular() = testSuspend {
        // non-null category will error
        assertFailsWith<IllegalArgumentException> {
            val payload = RecommendationRequest(
                environment = connector.credentials.environment.value,
                user = connector.clientUser.toRequestUser(),
                category = listOf()
            )

            ep.getPopular(payload)
        }

        // non-null id will error
        assertFailsWith<IllegalArgumentException> {
            val payload = RecommendationRequest(
                environment = connector.credentials.environment.value,
                user = connector.clientUser.toRequestUser(),
                id = "",
            )

            ep.getPopular(payload)
        }

        var payload = RecommendationRequest(
            environment = connector.credentials.environment.value,
            user = connector.clientUser.toRequestUser(),
        )
        var resp = ep.getPopular(payload)
        assertNotEquals(0, resp.results.size)
        checkResponse(resp)
    }

    @Test
    @Ignore
    fun testGetTrending() = testSuspend {
        // non-null category will error
        assertFailsWith<IllegalArgumentException> {
            val payload = RecommendationRequest(
                environment = connector.credentials.environment.value,
                user = connector.clientUser.toRequestUser(),
                category = listOf()
            )

            ep.getTrending(payload)
        }

        // non-null id will error
        assertFailsWith<IllegalArgumentException> {
            val payload = RecommendationRequest(
                environment = connector.credentials.environment.value,
                user = connector.clientUser.toRequestUser(),
                id = "",
            )

            ep.getTrending(payload)
        }

        var payload = RecommendationRequest(
            environment = connector.credentials.environment.value,
            user = connector.clientUser.toRequestUser(),
        )
        var resp = ep.getTrending(payload)
        assertNotEquals(0, resp.results.size)
        checkResponse(resp)
    }

    private fun checkResponse(resp: RecommendationResponse) {
        assertNotNull(resp.results)

        assertNotNull(resp.resultId)
        assertTrue { resp.resultId.isNotBlank() }

        assertNotNull(resp.size)
        assertTrue { resp.size > 0 }

        assertNotNull(resp.paginationTimestamp)
        assertTrue { resp.paginationTimestamp > 0 }

        assertNotNull(resp.time)
        assertTrue { resp.time.isNotBlank() }
    }
}