import ai.systema.TestConfig
import ai.systema.connection.internal.Connector
import ai.systema.constants.QueryItemType
import ai.systema.endpoint.EndpointSmartSearch
import ai.systema.model.request.QueryItem
import ai.systema.model.request.SmartSearchRequest
import ai.systema.model.response.SmartSearchResponse
import ai.systema.testSuspend
import kotlin.test.*

internal class EndpointSmartSearchImplTest {
    private val connector = Connector(TestConfig.configuration)
    private val ep = EndpointSmartSearch(connector)

    @Test
    @Ignore
    fun testSmartSearch() = testSuspend {
        // non-null query field is required
        assertFailsWith<IllegalArgumentException> {
            val payload = SmartSearchRequest(
                environment = connector.credentials.environment.value,
                user = connector.clientUser.toRequestUser(),
            )

            ep.smartSearch(payload)
        }

        var payload = SmartSearchRequest(
            environment = connector.credentials.environment.value,
            user = connector.clientUser.toRequestUser(),
            query = listOf(QueryItem(id = "WSH10_White", type = QueryItemType.Product))
        )

        var resp = ep.smartSearch(payload)
        assertNotEquals(0, resp.results.size)
        checkResponse(resp)
    }

    private fun checkResponse(resp: SmartSearchResponse) {
        assertNotNull(resp.results)

        assertNotNull(resp.resultId)
        assertTrue { resp.resultId.isNotBlank() }

        assertNotNull(resp.size)
        assertTrue { resp.size > 0 }

        assertNotNull(resp.total)
        assertTrue { resp.total > 0 }
        assertTrue { resp.size <= resp.total }

        assertNotNull(resp.facets)

        assertNotNull(resp.paginationTimestamp)
        assertTrue { resp.paginationTimestamp > 0 }

        assertNotNull(resp.time)
        assertTrue { resp.time.isNotBlank() }
    }
}