import ai.systema.TestConfig
import ai.systema.connection.internal.Connector
import ai.systema.endpoint.EndpointSmartSuggest
import ai.systema.model.request.SmartSuggestRequest
import ai.systema.model.response.SmartSuggestResponse
import ai.systema.testSuspend
import kotlin.test.*

internal class EndpointSmartSuggestImplTest {
    private val connector = Connector(TestConfig.configuration)
    private val ep = EndpointSmartSuggest(connector)

    @Test
    @Ignore
    fun testSmartSuggest() = testSuspend {
        // non-empty query field is required
        assertFailsWith<IllegalArgumentException> {
            val payload = SmartSuggestRequest(
                environment = connector.credentials.environment.value,
                user = connector.clientUser.toRequestUser(),
                query = ""
            )

            ep.smartSuggest(payload)
        }

        var payload = SmartSuggestRequest(
            environment = connector.credentials.environment.value,
            user = connector.clientUser.toRequestUser(),
            query = "WSH10",
        )

        var resp = ep.smartSuggest(payload)
        checkResponse(resp)
    }

    private fun checkResponse(resp: SmartSuggestResponse) {
        assertNotNull(resp.results)
        assertNotNull(resp.results.terms)
        assertTrue { resp.results.didYouMean.isNotEmpty() }
        assertNotNull(resp.results.categories)
        assertNotNull(resp.results.products)
        assertTrue { resp.results.products.isNotEmpty() }

        assertNotNull(resp.resultId)
        assertTrue { resp.resultId.isNotBlank() }

        assertNotNull(resp.time)
        assertTrue { resp.time.isNotBlank() }

        assertNotNull(resp.query)
        assertTrue { resp.query.isNotBlank() }
    }
}