package ai.systema.endpoint.internal

import ai.systema.TestConfig
import ai.systema.connection.internal.Connector
import ai.systema.endpoint.EndpointTracker
import ai.systema.helper.TrackEventBuilder
import ai.systema.helper.logging.SystemaLoggerFactory
import ai.systema.model.tracker.cart.CartItem
import ai.systema.model.tracker.view.ItemContainer
import ai.systema.model.tracker.view.prepContainerItem
import ai.systema.model.tracker.wishlist.WishlistItem
import ai.systema.testSuspend
import io.ktor.http.HttpStatusCode
import kotlin.test.Ignore
import kotlin.test.Test
import kotlin.test.assertEquals

internal class EndpointTrackerImplTest {
    private val logger = SystemaLoggerFactory.logger(EndpointTrackerImplTest::class.toString())

    @Test
    @Ignore
    fun testSendContainerShownEvent() = testSuspend {
        val connector = TestConfig.getConnector()
        val ep = EndpointTracker(connector)

        logger.debug("Testing ContainerShown")
        val containers = listOf(
            ItemContainer(
                resultId = "tw8fwtDsGNXD10O_",
                recItems = listOf(
                    prepContainerItem("tw8fwtDsGNXD10O_:t5hZuh0UeImGMxJ1")
                )
            )
        )
        val event = TrackEventBuilder(
            connector,
        ).setContainers(containers)
            .setUrl("https://sdk-test.systema.ai/products/24-MB05")
            .setReferrer("https://sdk-test.systema.ai/home/search")
            .buildContainerShownEvent()

        logger.debug("Event: ${event.type}")
        val resp = ep.sendContainerShownEvent(event)
        logger.warn("Received Response: ${resp.status}")
        assertEquals(HttpStatusCode.NoContent, resp.status)
    }

    @Test
    @Ignore
    fun testSendItemClickEvent() = testSuspend {
        val connector = TestConfig.getConnector()
        val ep = EndpointTracker(connector)

        logger.debug("Testing ItemClick")
        val event = TrackEventBuilder(
            connector,
        ).setProductId("24-MB05")
            .setRecId("tw8fwtDsGNXD10O_:t5hZuh0UeImGMxJ1")
            .setUrl("https://sdk-test.systema.ai/products/24-MB05")
            .setReferrer("https://sdk-test.systema.ai/home/search")
            .buildItemClickEvent()

        logger.debug("Event: ${event.type}")
        val resp = ep.sendItemClickEvent(event)
        logger.warn("Received Response: ${resp.status}")
        assertEquals(HttpStatusCode.NoContent, resp.status)
    }

    @Test
    @Ignore
    fun testSendPageViewEvent() = testSuspend {
        val connector = TestConfig.getConnector()
        val ep = EndpointTracker(connector)

        logger.debug("Testing PageView")
        val event = TrackEventBuilder(
            connector,
        ).setProductId("24-MB05")
            .setRecId("tw8fwtDsGNXD10O_:t5hZuh0UeImGMxJ1")
            .setUrl("https://sdk-test.systema.ai/products/24-MB05")
            .setReferrer("https://sdk-test.systema.ai/home/search")
            .buildPagedViewEvent()

        logger.debug("Event: ${event.type}")
        val resp = ep.sendPageViewEvent(event)
        logger.warn("Received Response: ${resp.status}")
        assertEquals(HttpStatusCode.NoContent, resp.status)
    }

    @Test
    @Ignore
    fun testCartItemAcquiredEvent() = testSuspend {
        val connector = TestConfig.getConnector()
        val ep = EndpointTracker(connector)

        val items: List<CartItem> = listOf(
            CartItem(itemId = "24-MB02", quantity = 1),
            CartItem(itemId = "24-MB05", quantity = 1),
        )
        logger.debug("Testing CartItemAcquired")
        val event = TrackEventBuilder(
            connector,
        ).setCartItems(items)
            .setUrl("https://sdk-test.systema.ai/products/24-MB05")
            .setReferrer("https://sdk-test.systema.ai/home/search")
            .buildCartItemAcquired()

        logger.debug("Event: ${event.type}")
        val resp = ep.sendCartItemAcquiredEvent(event)
        logger.warn("Received Response: ${resp.status}")
        assertEquals(HttpStatusCode.NoContent, resp.status)
    }

    @Test
    @Ignore
    fun testCartItemRelinquishedEvent() = testSuspend {
        val connector = TestConfig.getConnector()
        val ep = EndpointTracker(connector)

        val item = CartItem(itemId = "24-MB02", quantity = 1)
        logger.debug("Testing CartItemRelinquished")
        val event = TrackEventBuilder(
            connector,
        ).setCartItem(item)
            .setUrl("https://sdk-test.systema.ai/products/24-MB05")
            .setReferrer("https://sdk-test.systema.ai/home/search")
            .buildCartItemRelinquished()

        logger.debug("Event: ${event.type}")
        val resp = ep.sendCartItemRelinquishedEvent(event)
        logger.warn("Received Response: ${resp.status}")
        assertEquals(HttpStatusCode.NoContent, resp.status)
    }

    @Test
    @Ignore
    fun testWishlistItemAcquiredEvent() = testSuspend {
        val connector = TestConfig.getConnector()
        val ep = EndpointTracker(connector)

        val items = listOf(
            WishlistItem(itemId = "24-MB02"),
            WishlistItem(itemId = "24-MB05"),
        )
        logger.debug("Testing CartItemAcquired")
        val event = TrackEventBuilder(
            connector,
        ).setWishlistItems(items)
            .setUrl("https://sdk-test.systema.ai/products/24-MB05")
            .setReferrer("https://sdk-test.systema.ai/home/search")
            .buildWishlistItemAcquired()

        logger.debug("Event: ${event.type}")
        val resp = ep.sendWishlistItemAcquiredEvent(event)
        logger.warn("Received Response: ${resp.status}")
        assertEquals(HttpStatusCode.NoContent, resp.status)
    }

    @Test
//    @Ignore
    fun testWishlistItemRelinquishedEvent() = testSuspend {
        val connector = TestConfig.getConnector()
        val ep = EndpointTracker(connector)

        val item = WishlistItem(itemId = "24-MB02")
        logger.debug("Testing CartItemRelinquished")
        val event = TrackEventBuilder(
            connector,
        ).setWishlistItem(item)
            .setUrl("https://sdk-test.systema.ai/products/24-MB05")
            .setReferrer("https://sdk-test.systema.ai/home/search")
            .buildWishlistItemRelinquished()

        logger.debug("Event: ${event.type}")
        val resp = ep.sendWishlistItemRelinquishedEvent(event)
        logger.warn("Received Response: ${resp.status}")
        assertEquals(HttpStatusCode.NoContent, resp.status)
    }
}