package ai.systema.android.listener

import ai.systema.client.SystemaAI
import android.view.View
import io.ktor.client.statement.HttpResponse
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.Dispatchers

public class SystemaOnAttachStateChangeListener(
    systema: SystemaAI,
    tagMapping: Map<String, Int>,
    dispatcher: CoroutineDispatcher = Dispatchers.IO,
    callback: (Result<HttpResponse>) -> Unit
) : View.OnAttachStateChangeListener, SystemaCompositeListener<View.OnAttachStateChangeListener>() {

    init {
        addListener(SystemaEventListener(systema, tagMapping, dispatcher, callback))
    }

    override fun onViewAttachedToWindow(v: View?) {
        v ?: return
        for (listener in this.getListeners()) {
            listener.onViewAttachedToWindow(v)
        }
    }

    override fun onViewDetachedFromWindow(v: View?) {
        v ?: return
        for (listener in this.getListeners()) {
            listener.onViewDetachedFromWindow(v)
        }
    }
}
