package ai.systema.endpoint.internal

import ai.systema.connection.RequestOptions
import ai.systema.connection.internal.Connector
import ai.systema.endpoint.EndpointTracker
import ai.systema.endpoint.SystemaRoutes
import ai.systema.enums.EndpointType
import ai.systema.model.tracker.cart.CartItemAcquiredEvent
import ai.systema.model.tracker.cart.CartItemAcquisitionCompleteEvent
import ai.systema.model.tracker.cart.CartItemRelinquishedEvent
import ai.systema.model.tracker.view.ContainerShownEvent
import ai.systema.model.tracker.view.ItemClickEvent
import ai.systema.model.tracker.view.PageViewEvent
import ai.systema.model.tracker.wishlist.WishlistItemAcquiredEvent
import ai.systema.model.tracker.wishlist.WishlistItemRelinquishedEvent
import io.ktor.client.statement.HttpResponse
import io.ktor.http.HttpMethod

internal class EndpointTrackerImpl(
    private val connector: Connector,
) : EndpointTracker {

    override suspend fun sendPageViewEvent(event: PageViewEvent, requestOptions: RequestOptions): HttpResponse {
        return this.sendRequest(event, requestOptions)
    }

    override suspend fun sendItemClickEvent(event: ItemClickEvent, requestOptions: RequestOptions): HttpResponse {
        return this.sendRequest(event, requestOptions)
    }

    override suspend fun sendContainerShownEvent(
        event: ContainerShownEvent,
        requestOptions: RequestOptions
    ): HttpResponse {
        return this.sendRequest(event, requestOptions)
    }

    override suspend fun sendCartItemAcquiredEvent(
        event: CartItemAcquiredEvent,
        requestOptions: RequestOptions
    ): HttpResponse {
        return this.sendRequest(event, requestOptions)
    }

    override suspend fun sendCartItemRelinquishedEvent(
        event: CartItemRelinquishedEvent,
        requestOptions: RequestOptions
    ): HttpResponse {
        return this.sendRequest(event, requestOptions)
    }

    override suspend fun sendCartItemAcquisitionCompleteEvent(
        event: CartItemAcquisitionCompleteEvent,
        requestOptions: RequestOptions
    ): HttpResponse {
        return this.sendRequest(event, requestOptions)
    }

    override suspend fun sendWishlistItemAcquiredEvent(
        event: WishlistItemAcquiredEvent,
        requestOptions: RequestOptions
    ): HttpResponse {
        return this.sendRequest(event, requestOptions)
    }

    override suspend fun sendWishlistItemRelinquishedEvent(
        event: WishlistItemRelinquishedEvent,
        requestOptions: RequestOptions
    ): HttpResponse {
        return this.sendRequest(event, requestOptions)
    }

    private suspend fun sendRequest(
        body: Any,
        requestOptions: RequestOptions
    ): HttpResponse {
        return connector.callApi(
            HttpMethod.Post,
            EndpointType.Tracker,
            SystemaRoutes.Tracker,
            requestOptions,
            body
        )
    }
}
