package ai.systema.ios

import ai.systema.client.SystemaAI
import ai.systema.enums.EndpointType
import ai.systema.enums.EnvironmentType
import ai.systema.helper.logging.SystemaLogLevel
import io.github.aakira.napier.DebugAntilog
import io.github.aakira.napier.Napier

public class SystemaAIClient {
    public suspend fun initialize(
        clientID: String,
        apiKey: String = "NOT_REQUIRED",
        environment: EnvironmentType = EnvironmentType.DEV,
        logLevel: SystemaLogLevel = SystemaLogLevel.INFO,
        proxyUrls: Map<EndpointType, String> = mapOf(),
        meta: Map<String, Any> = mapOf()
    ): SystemaAI {
        val systema = SystemaAI(
            clientID = clientID,
            apiKey = apiKey,
            environment = environment,
            logLevel = logLevel,
            proxyUrls = proxyUrls,
            meta = meta,
            kvStore = SystemaIosStorage(),
            deviceManager = IosDeviceManager()
        )

        Napier.base(DebugAntilog())
        systema.initialize()
        return systema
    }
}
