package ai.systema.client.internal

import ai.systema.client.Recommender
import ai.systema.connection.RequestOptions
import ai.systema.connection.internal.Connector
import ai.systema.endpoint.EndpointRecommendation
import ai.systema.helper.internal.ApplicationDispatcher
import ai.systema.model.request.CartRecommendationRequest
import ai.systema.model.request.RecommendationRequest
import ai.systema.model.response.RecommendationResponse
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch

internal class RecommenderImpl(
    private val connector: Connector,
    private val endpoint: EndpointRecommendation
) : Recommender {

    override suspend fun getRelated(
        payload: RecommendationRequest,
        requestOptions: RequestOptions?
    ): Result<RecommendationResponse> {
        return try {
            val resp = endpoint.getRelated(connector.injectSystemaSettings(payload))
            Result.success(resp)
        } catch (ex: Exception) {
            Result.failure(ex)
        }
    }

    override fun getRelated(
        payload: RecommendationRequest,
        requestOptions: RequestOptions?,
        result: (Result<RecommendationResponse>) -> Unit
    ) {
        CoroutineScope(ApplicationDispatcher).launch {
            getRelated(payload, requestOptions) { resp ->
                result(resp)
            }
        }
    }

    override suspend fun getComplementary(
        payload: RecommendationRequest,
        requestOptions: RequestOptions?
    ): Result<RecommendationResponse> {
        return try {
            val resp = endpoint.getComplementary(connector.injectSystemaSettings(payload))
            Result.success(resp)
        } catch (ex: Exception) {
            Result.failure(ex)
        }
    }

    override fun getComplementary(
        payload: RecommendationRequest,
        requestOptions: RequestOptions?,
        result: (Result<RecommendationResponse>) -> Unit
    ) {
        CoroutineScope(ApplicationDispatcher).launch {
            getComplementary(payload, requestOptions) { resp ->
                result(resp)
            }
        }
    }

    override suspend fun getSimilar(
        payload: RecommendationRequest,
        requestOptions: RequestOptions?
    ): Result<RecommendationResponse> {
        return try {
            val resp = endpoint.getSimilar(connector.injectSystemaSettings(payload))
            Result.success(resp)
        } catch (ex: Exception) {
            Result.failure(ex)
        }
    }

    override fun getSimilar(
        payload: RecommendationRequest,
        requestOptions: RequestOptions?,
        result: (Result<RecommendationResponse>) -> Unit
    ) {
        CoroutineScope(ApplicationDispatcher).launch {
            getSimilar(payload, requestOptions) { resp ->
                result(resp)
            }
        }
    }

    override suspend fun getCategoryTrending(
        payload: RecommendationRequest,
        requestOptions: RequestOptions?
    ): Result<RecommendationResponse> {
        return try {
            val resp = endpoint.getCategoryTrending(connector.injectSystemaSettings(payload))
            Result.success(resp)
        } catch (ex: Exception) {
            Result.failure(ex)
        }
    }

    override fun getCategoryTrending(
        payload: RecommendationRequest,
        requestOptions: RequestOptions?,
        result: (Result<RecommendationResponse>) -> Unit
    ) {
        CoroutineScope(ApplicationDispatcher).launch {
            getCategoryTrending(payload, requestOptions) { resp ->
                result(resp)
            }
        }
    }

    override suspend fun getCategoryPopular(
        payload: RecommendationRequest,
        requestOptions: RequestOptions?
    ): Result<RecommendationResponse> {
        return try {
            val resp = endpoint.getCategoryPopular(connector.injectSystemaSettings(payload))
            Result.success(resp)
        } catch (ex: Exception) {
            Result.failure(ex)
        }
    }

    override fun getCategoryPopular(
        payload: RecommendationRequest,
        requestOptions: RequestOptions?,
        result: (Result<RecommendationResponse>) -> Unit
    ) {
        CoroutineScope(ApplicationDispatcher).launch {
            getCategoryPopular(payload, requestOptions) { resp ->
                result(resp)
            }
        }
    }

    override suspend fun getTrending(
        payload: RecommendationRequest,
        requestOptions: RequestOptions?
    ): Result<RecommendationResponse> {
        return try {
            val resp = endpoint.getTrending(connector.injectSystemaSettings(payload))
            Result.success(resp)
        } catch (ex: Exception) {
            Result.failure(ex)
        }
    }

    override fun getTrending(
        payload: RecommendationRequest,
        requestOptions: RequestOptions?,
        result: (Result<RecommendationResponse>) -> Unit
    ) {
        CoroutineScope(ApplicationDispatcher).launch {
            getTrending(payload, requestOptions) { resp ->
                result(resp)
            }
        }
    }

    override suspend fun getPopular(
        payload: RecommendationRequest,
        requestOptions: RequestOptions?
    ): Result<RecommendationResponse> {
        return try {
            val resp = endpoint.getPopular(connector.injectSystemaSettings(payload))
            Result.success(resp)
        } catch (ex: Exception) {
            Result.failure(ex)
        }
    }

    override fun getPopular(
        payload: RecommendationRequest,
        requestOptions: RequestOptions?,
        result: (Result<RecommendationResponse>) -> Unit
    ) {
        CoroutineScope(ApplicationDispatcher).launch {
            getPopular(payload, requestOptions) { resp ->
                result(resp)
            }
        }
    }

    override suspend fun getCartRelated(
        payload: CartRecommendationRequest,
        requestOptions: RequestOptions?
    ): Result<RecommendationResponse> {
        return try {
            val resp = endpoint.getCartRelated(connector.injectSystemaSettings(payload))
            Result.success(resp)
        } catch (ex: Exception) {
            Result.failure(ex)
        }
    }

    override fun getCartRelated(
        payload: CartRecommendationRequest,
        requestOptions: RequestOptions?,
        result: (Result<RecommendationResponse>) -> Unit
    ) {
        CoroutineScope(ApplicationDispatcher).launch {
            getCartRelated(payload, requestOptions) { resp ->
                result(resp)
            }
        }
    }

    override suspend fun getCartComplementary(
        payload: CartRecommendationRequest,
        requestOptions: RequestOptions?
    ): Result<RecommendationResponse> {
        return try {
            val resp = endpoint.getCartComplementary(connector.injectSystemaSettings(payload))
            Result.success(resp)
        } catch (ex: Exception) {
            Result.failure(ex)
        }
    }

    override fun getCartComplementary(
        payload: CartRecommendationRequest,
        requestOptions: RequestOptions?,
        result: (Result<RecommendationResponse>) -> Unit
    ) {
        CoroutineScope(ApplicationDispatcher).launch {
            getCartComplementary(payload, requestOptions) { resp ->
                result(resp)
            }
        }
    }
}
