package ai.systema.client.internal

import ai.systema.client.SmartSearch
import ai.systema.connection.RequestOptions
import ai.systema.connection.internal.Connector
import ai.systema.endpoint.EndpointSmartSearch
import ai.systema.helper.internal.ApplicationDispatcher
import ai.systema.model.request.SmartSearchRequest
import ai.systema.model.response.SmartSearchResponse
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch

internal class SmartSearchImpl(
    private val connector: Connector,
    private val endpoint: EndpointSmartSearch
) : SmartSearch {

    override suspend fun smartSearch(
        payload: SmartSearchRequest,
        requestOptions: RequestOptions?
    ): Result<SmartSearchResponse> {
        return try {
            val resp = endpoint.smartSearch(connector.injectSystemaSettings(payload))
            Result.success(resp)
        } catch (ex: Exception) {
            Result.failure(ex)
        }
    }

    override fun smartSearch(
        payload: SmartSearchRequest,
        requestOptions: RequestOptions?,
        result: (Result<SmartSearchResponse>) -> Unit
    ) {
        CoroutineScope(ApplicationDispatcher).launch {
            smartSearch(payload, requestOptions) { resp ->
                result(resp)
            }
        }
    }
}
