package ai.systema.client.internal

import ai.systema.client.SmartSuggest
import ai.systema.connection.RequestOptions
import ai.systema.connection.internal.Connector
import ai.systema.endpoint.EndpointSmartSuggest
import ai.systema.helper.internal.ApplicationDispatcher
import ai.systema.model.request.SmartSuggestRequest
import ai.systema.model.response.SmartSuggestResponse
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch

internal class SmartSuggestImpl(
    private val connector: Connector,
    private val endpoint: EndpointSmartSuggest
) : SmartSuggest {

    override suspend fun smartSuggest(
        payload: SmartSuggestRequest,
        requestOptions: RequestOptions?
    ): Result<SmartSuggestResponse> {
        return try {
            val resp = endpoint.smartSuggest(connector.injectSystemaSettings(payload))
            Result.success(resp)
        } catch (ex: Exception) {
            Result.failure(ex)
        }
    }

    override fun smartSuggest(
        payload: SmartSuggestRequest,
        requestOptions: RequestOptions?,
        result: (Result<SmartSuggestResponse>) -> Unit
    ) {
        CoroutineScope(ApplicationDispatcher).launch {
            smartSuggest(payload, requestOptions) { resp ->
                result(resp)
            }
        }
    }
}
