package ai.systema.client.internal

import ai.systema.TestConfig
import ai.systema.client.SmartSearch
import ai.systema.constants.QueryItemType
import ai.systema.endpoint.EndpointSmartSearch
import ai.systema.exception.SystemaApiException
import ai.systema.helper.SmartSearchMockClient
import ai.systema.model.request.QueryItem
import ai.systema.model.request.SmartSearchRequest
import ai.systema.testSuspend
import io.mockk.coEvery
import io.mockk.mockk
import kotlin.test.Test
import kotlin.test.assertEquals
import kotlin.test.assertNotEquals
import kotlin.test.assertNull

internal open class SmartSearchImplTest : SmartSearchMockClient() {
    @Test
    fun testSmartSearch() = testSuspend {
        val connector = TestConfig.getConnector(this.initEngine())

        // check for failure
        val ep: EndpointSmartSearch = mockk()
        coEvery { ep.smartSearch(any(), any()) } throws SystemaApiException(IllegalArgumentException("test"))
        var searcher: SmartSearch = SmartSearchImpl(connector, ep)
        var payload = SmartSearchRequest(
            query = listOf(QueryItem(id = "WSH10_White", type = QueryItemType.Product))
        )
        searcher.smartSearch(payload).fold(
            onSuccess = { resp ->
                assertNull(resp)
            },
            onFailure = { ex ->
                assertEquals(SystemaApiException::class, ex::class)
                assertEquals("API error occurred", ex.message)
            }
        )

        // check for success
        payload = SmartSearchRequest(
            query = listOf(QueryItem(id = "WSH10_White", type = QueryItemType.Product))
        )
        searcher = SmartSearch(connector)
        searcher.smartSearch(payload).fold(
            onSuccess = { resp ->
                assertNotEquals(0, resp.size)
                this.checkSmartSearchResponse(resp)
            },
            onFailure = { ex ->
                throw IllegalStateException("Should not error", ex)
            }
        )
    }

    @Test
    fun testSmartSearchWithCallback() = testSuspend {
        val connector = TestConfig.getConnector(this.initEngine())
        val searcher = SmartSearch(connector)

        val payload = SmartSearchRequest(
            query = listOf(QueryItem(id = "WSH10_White", type = QueryItemType.Product))
        )

        searcher.smartSearch(payload) {
            it.onSuccess { resp ->
                assertNotEquals(0, resp.results.size)
                this.checkSmartSearchResponse(resp)
            }
            it.onFailure { ex ->
                throw IllegalStateException("Should not error", ex)
            }
        }
    }
}
