package ai.systema.client.internal

import ai.systema.TestConfig
import ai.systema.client.SmartSuggest
import ai.systema.endpoint.EndpointSmartSuggest
import ai.systema.exception.SystemaApiException
import ai.systema.helper.SmartSuggestMockClient
import ai.systema.model.request.SmartSuggestRequest
import ai.systema.testSuspend
import io.mockk.coEvery
import io.mockk.mockk
import kotlin.test.Test
import kotlin.test.assertEquals
import kotlin.test.assertNull

internal open class SmartSuggestImplTest : SmartSuggestMockClient() {
    @Test
    fun testSmartSuggest() = testSuspend {
        val connector = TestConfig.getConnector(this.initEngine())

        // check for failure
        val ep: EndpointSmartSuggest = mockk()
        coEvery { ep.smartSuggest(any(), any()) } throws SystemaApiException(IllegalArgumentException("test"))
        var suggest: SmartSuggest = SmartSuggestImpl(connector, ep)
        var payload = SmartSuggestRequest(
            query = "WSH10"
        )
        suggest.smartSuggest(payload).fold(
            onSuccess = { resp ->
                assertNull(resp)
            },
            onFailure = { ex ->
                assertEquals(SystemaApiException::class, ex::class)
                assertEquals("API error occurred", ex.message)
            }
        )

        // check for success
        suggest = SmartSuggest(connector)
        payload = SmartSuggestRequest(
            query = "WSH10"
        )
        suggest.smartSuggest(payload).fold(
            onSuccess = { resp ->
                this.checkSmartSuggestResponse(resp)
            },
            onFailure = { ex ->
                throw IllegalStateException("Should not error", ex)
            }
        )
    }

    @Test
    fun testSmartSuggestWithCallback() = testSuspend {
        val connector = TestConfig.getConnector(this.initEngine())
        val searcher = SmartSuggest(connector)
        val payload = SmartSuggestRequest(
            query = "WSH10"
        )

        searcher.smartSuggest(payload) {
            it.onSuccess { resp ->
                this.checkSmartSuggestResponse(resp)
            }
            it.onFailure { ex ->
                throw IllegalStateException("Should not error", ex)
            }
        }
    }
}
