package ai.systema.android.listener

public open class SystemaCompositeListener<T> {
    private val listenerList: MutableMap<Int, T> = mutableMapOf()

    public fun getListeners(): List<T> {
        return listenerList.values.toList()
    }

    public fun addListeners(listeners: Array<T>): SystemaCompositeListener<T> {
        for (l in listeners) {
            listenerList[l.hashCode()] = l
        }
        return this
    }

    public fun addListener(listener: T?): SystemaCompositeListener<T> {
        listener?.let { listenerList[listener.hashCode()] = listener }
        return this
    }

    public fun removeListener(listener: T): T? {
        if (listenerList.containsKey(listener.hashCode())) {
            listenerList.remove(listener.hashCode())
        }

        return null
    }

    public fun clearAll() {
        listenerList.clear()
    }
}
