package ai.systema.ios

import ai.systema.configuration.SystemaKVStore
import ai.systema.helper.logging.SystemaLogger
import platform.Foundation.NSUserDefaults

public open class SystemaIosStorage : SystemaKVStore {

    // TODO: Change this to save to file, or this will do I think instead of file?
    private var userDefaults: NSUserDefaults = NSUserDefaults()

    override suspend fun read(key: String): String? {
        SystemaLogger.debug("read - $key", tag = TAG)
        return userDefaults.objectForKey(key).toString()
    }

    override suspend fun delete(key: String): String? {
        SystemaLogger.debug("delete - $key", tag = TAG)
        userDefaults.removeObjectForKey(key)
        return key
    }

    override suspend fun write(key: String, value: String) {
        SystemaLogger.debug("write - $key : $value\"", tag = TAG)
        userDefaults.setObject(value, key)
    }

    public companion object {
        public val TAG: String? = SystemaIosStorage::class.simpleName
    }
}
