package ai.systema.android

import ai.systema.constants.SystemaTags
import ai.systema.model.SystemaClientID
import ai.systema.model.index.Product
import android.view.View

internal object SystemaTagger {
    private var lastPageUrl: String = ""
    private const val missingTagMapMsg = "is not in tagMapping"

    internal fun setObserved(v: View, tagMapping: Map<String, Int>, flag: Boolean): View {
        val keyObserved = tagMapping[SystemaTags.Observed]
            ?: throw IllegalArgumentException("'${SystemaTags.Observed}' $missingTagMapMsg")
        v.setTag(keyObserved, flag.toString())
        return v
    }

    internal fun setVisible(v: View, tagMapping: Map<String, Int>, flag: Boolean): View {
        val keyVisible = tagMapping[SystemaTags.Visible]
            ?: throw IllegalArgumentException("'${SystemaTags.Visible}' $missingTagMapMsg")
        v.setTag(keyVisible, flag.toString())
        return v
    }

    internal fun setMonitoringEnabled(v: View, tagMapping: Map<String, Int>, flag: Boolean): View {
        val keyMonitoring = tagMapping[SystemaTags.MonitoringEnabled]
            ?: throw IllegalArgumentException("'${SystemaTags.MonitoringEnabled}' $missingTagMapMsg")
        v.setTag(keyMonitoring, flag.toString())
        return v
    }

    internal fun setProductId(v: View, product: Product, tagMapping: Map<String, Int>): View {
        val keyProductId = tagMapping[SystemaTags.ProductId]
            ?: throw IllegalArgumentException("'${SystemaTags.ProductId}' $missingTagMapMsg")
        v.setTag(keyProductId, product.id)
        return v
    }

    internal fun setProductPrice(v: View, product: Product, tagMapping: Map<String, Int>): View {
        val keyProductPrice = tagMapping[SystemaTags.ProductPrice]
            ?: throw IllegalArgumentException("'${SystemaTags.ProductPrice}' $missingTagMapMsg")
        v.setTag(keyProductPrice, product.price)
        return v
    }

    internal fun setProductCurrency(v: View, product: Product, tagMapping: Map<String, Int>): View {
        val keyProductCurrency = tagMapping[SystemaTags.ProductCurrency]
            ?: throw IllegalArgumentException("'${SystemaTags.ProductCurrency}' $missingTagMapMsg")
        v.setTag(keyProductCurrency, product.currency)
        return v
    }

    internal fun setRecId(v: View, product: Product, tagMapping: Map<String, Int>): View {
        val keyRecId = tagMapping[SystemaTags.RecId]
            ?: throw IllegalArgumentException("'${SystemaTags.RecId}' $missingTagMapMsg")
        v.setTag(keyRecId, product.recId)
        return v
    }

    internal fun setLastPageUrl(referrerUrl: String) {
        this.lastPageUrl = referrerUrl
    }

    internal fun setPageUrl(v: View, url: String, tagMapping: Map<String, Int>, clientID: SystemaClientID): View {
        val keyPageUrl = tagMapping[SystemaTags.PageUrl]
            ?: throw IllegalArgumentException("'${SystemaTags.PageUrl}' $missingTagMapMsg")

        // If it is a relative URL, we append to a mock baseURL
        var pageUrl = url
        if (!pageUrl.startsWith("http")) {
            pageUrl = "https://$clientID.apps.systema.ai/${pageUrl.trimStart('/')}"
        }

        v.setTag(keyPageUrl, pageUrl)

        return v
    }

    internal fun setProductUrl(
        v: View,
        product: Product,
        tagMapping: Map<String, Int>,
        clientID: SystemaClientID
    ): View {
        setPageUrl(v, product.link, tagMapping, clientID)
        return v
    }

    internal fun setContainerUrl(
        v: View,
        containerId: String,
        tagMapping: Map<String, Int>,
        clientID: SystemaClientID
    ): View {
        val keyUrl = tagMapping[SystemaTags.ContainerUrl]
            ?: throw IllegalArgumentException("'${SystemaTags.ContainerUrl}' $missingTagMapMsg")

        // Note: We need a proper URL, and therefore we create a mock URL for the container based on the resultId
        v.setTag(
            keyUrl,
            "https://$clientID.apps.systema.ai/containers/$containerId"
        )

        return v
    }

    internal fun setResultId(v: View, resultId: String, tagMapping: Map<String, Int>): View {
        val keyResultId = tagMapping[SystemaTags.ResultId]
            ?: throw IllegalArgumentException("'${SystemaTags.ResultId}' $missingTagMapMsg")

        v.setTag(keyResultId, resultId)

        // when a new result Id is set, set the observed to be false
        if (v.hasSystemaTag(SystemaTags.Observed, tagMapping) &&
            v.getSystemaTagVal(SystemaTags.Observed, tagMapping) == true.toString()
        ) {
            setObserved(v, tagMapping, false)
        }

        return v
    }

    internal fun getProductId(view: View?, tagMapping: Map<String, Int>): String? {
        if (view == null) {
            return null
        }

        return view.getSystemaTagVal(SystemaTags.ProductId, tagMapping)
    }

    internal fun getProductPrice(view: View?, tagMapping: Map<String, Int>): String? {
        if (view == null) {
            return null
        }

        return view.getSystemaTagVal(SystemaTags.ProductPrice, tagMapping)
    }

    internal fun getProductCurrency(view: View?, tagMapping: Map<String, Int>): String? {
        if (view == null) {
            return null
        }

        return view.getSystemaTagVal(SystemaTags.ProductCurrency, tagMapping)
    }

    internal fun getRecId(view: View?, tagMapping: Map<String, Int>): String? {
        if (view == null) {
            return null
        }

        return view.getSystemaTagVal(SystemaTags.RecId, tagMapping)
    }

    internal fun getLastPageUrl(): String {
        return this.lastPageUrl
    }

    internal fun getPageUrl(view: View?, tagMapping: Map<String, Int>): String? {
        if (view == null) {
            return null
        }

        return view.getSystemaTagVal(SystemaTags.PageUrl, tagMapping)
    }

    internal fun getResultId(view: View?, tagMapping: Map<String, Int>): String? {
        if (view == null) {
            return null
        }

        return view.getSystemaTagVal(SystemaTags.ResultId, tagMapping)
    }

    internal fun getObserved(view: View?, tagMapping: Map<String, Int>): String? {
        if (view == null) {
            return null
        }

        return view.getSystemaTagVal(SystemaTags.Observed, tagMapping)
    }

    internal fun getVisible(view: View?, tagMapping: Map<String, Int>): String? {
        if (view == null) {
            return null
        }

        return view.getSystemaTagVal(SystemaTags.Visible, tagMapping)
    }

    internal fun getMonitoringEnabled(view: View?, tagMapping: Map<String, Int>): String? {
        if (view == null) {
            return null
        }

        return view.getSystemaTagVal(SystemaTags.MonitoringEnabled, tagMapping)
    }

    internal fun hasMonitoringEnabled(view: View, tagMapping: Map<String, Int>): Boolean {
        return view.hasSystemaTag(SystemaTags.MonitoringEnabled, tagMapping) &&
            view.getSystemaTagVal(SystemaTags.MonitoringEnabled, tagMapping) == true.toString()
    }

    internal fun getContainerUrl(view: View?, tagMapping: Map<String, Int>): String? {
        if (view == null) {
            return null
        }

        return view.getSystemaTagVal(SystemaTags.ContainerUrl, tagMapping)
    }
}
