package ai.systema.android.listener

import ai.systema.helper.BaseListenerTest
import ai.systema.testSuspend
import android.view.View
import io.mockk.Runs
import io.mockk.every
import io.mockk.just
import io.mockk.mockk
import io.mockk.mockkClass
import kotlinx.coroutines.ExperimentalCoroutinesApi
import kotlin.test.Test
import kotlin.test.assertContentEquals
import kotlin.test.assertEquals
import kotlin.test.assertTrue

internal class SystemaParentOnScrollChangeListenerTest : BaseListenerTest() {

    @Test
    fun testAddOnScrollChangeListener() = testSuspend {
        val (systema, tagMapping) = getConfig()

        val mockListener = mockkClass(View.OnScrollChangeListener::class)
        val recContainer = mockk<View>()
        every { recContainer.id } returns 1
        var compositeListener = SystemaOnParentScrollChangeListener(systema, tagMapping) {}
        compositeListener.addChildContainer(recContainer)
        compositeListener.addListener(mockListener)
        assertEquals(2, compositeListener.getListeners().size)
        assertTrue { compositeListener.getListeners()[0] is SystemaEventListener }

        val listeners = compositeListener.getListeners()
        compositeListener.addListener(null)
        assertContentEquals(listeners, compositeListener.getListeners())
    }

    @Test
    @ExperimentalCoroutinesApi
    fun testOnScrollChange() = testSuspend {
        val (systema, tagMapping) = getConfig()
        val recContainer = mockk<View>()
        every { recContainer.id } returns 1
        every { recContainer.isShown } returns true
        every { recContainer.getGlobalVisibleRect(any()) } returns true
        val mockListener = mockkClass(View.OnScrollChangeListener::class)
        every { mockListener.onScrollChange(any(), any(), any(), any(), any()) } just Runs
        val compositeListener =
            SystemaOnParentScrollChangeListener(systema, tagMapping, dispatcher = testDispatcher) {}
        compositeListener.addListener(mockListener)
        compositeListener.addChildContainer(recContainer)

        val onChangeListenerWithNullView = compositeListener.onScrollChange(
            containerParent = null, scrollX = 1, scrollY = 1, oldScrollX = 0, oldScrollY = 0
        )
        assertEquals(onChangeListenerWithNullView, kotlin.Unit)

        val mockView = mockk<View>(relaxed = true)
        every { mockView.id } returns 2
        compositeListener.onScrollChange(
            containerParent = mockView, scrollX = 1, scrollY = 1, oldScrollX = 0, oldScrollY = 0
        )
    }
}
