package ai.systema.configuration.internal.extension

import ai.systema.configuration.Configuration
import ai.systema.helper.SystemaDeviceManager
import ai.systema.helper.internal.JsonNonStrict
import ai.systema.helper.logging.SystemaLogLevel
import ai.systema.helper.logging.toKtorLogLevel
import io.ktor.client.HttpClient
import io.ktor.client.HttpClientConfig
import io.ktor.client.plugins.HttpTimeout
import io.ktor.client.plugins.UserAgent
import io.ktor.client.plugins.contentnegotiation.ContentNegotiation
import io.ktor.client.plugins.logging.Logger
import io.ktor.client.plugins.logging.Logging
import io.ktor.client.plugins.logging.SIMPLE
import io.ktor.serialization.kotlinx.json.json

internal fun Configuration.prepareHttpClient(logLevel: SystemaLogLevel, deviceManager: SystemaDeviceManager) =
    engine?.let {
        HttpClient(it) { configure(logLevel, deviceManager) }
    } ?: HttpClient { configure(logLevel, deviceManager) }

internal fun HttpClientConfig<*>.configure(logLevel: SystemaLogLevel, deviceManager: SystemaDeviceManager) {
    install(ContentNegotiation) {
        json(JsonNonStrict)
    }

    install(Logging) {
        level = toKtorLogLevel(logLevel)
        logger = Logger.SIMPLE
    }

    install(UserAgent) {
        agent = deviceManager.getUserAgent()
    }

    install(HttpTimeout)
}
