package ai.systema.connection.internal

import ai.systema.configuration.Credentials
import ai.systema.enums.EndpointType
import io.ktor.http.Url

/**
 * Hosts related configurations
 */
internal val Credentials.hosts
    get() = mapOf(
        EndpointType.DynamicConfig to dynamicConfigHost,
        EndpointType.Recommend to recommendHost,
        EndpointType.Search to searchHost,
        EndpointType.Suggest to suggestHost,
        EndpointType.Tracker to trackerHost
    )

internal val Credentials.dynamicConfigHost
    get() = proxyUrls[EndpointType.DynamicConfig] ?: Url("https://discover.systema.cloud") // not active

internal val Credentials.trackerHost
    get() = proxyUrls[EndpointType.Tracker]
        ?: Url("https://tracker.${this.clientID}.${this.environment.value}.systema.cloud")

internal val Credentials.searchHost
    get() = proxyUrls[EndpointType.Search]
        ?: Url("https://search.${this.clientID}.${this.environment.value}.systema.cloud")

internal val Credentials.suggestHost
    get() = proxyUrls[EndpointType.Search]
        ?: Url("https://suggest.${this.clientID}.${this.environment.value}.systema.cloud")

internal val Credentials.recommendHost
    get() = proxyUrls[EndpointType.Recommend]
        ?: Url("https://recommend.${this.clientID}.${this.environment.value}.systema.cloud")
