package ai.systema.helper.internal

import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.json.Json

internal val JsonNoDefaults = Json {
    encodeDefaults = false
}

@OptIn(ExperimentalSerializationApi::class)
internal val JsonNonStrict = Json {
    ignoreUnknownKeys = true
    isLenient = true
    allowSpecialFloatingPointValues = true
    encodeDefaults = true
    explicitNulls = false
}
