package ai.systema.client.internal

import ai.systema.TestConfig
import ai.systema.client.SmartSearch
import ai.systema.connection.RequestOptions
import ai.systema.constants.QueryItemType
import ai.systema.endpoint.EndpointSmartSearch
import ai.systema.exception.SystemaApiException
import ai.systema.helper.SmartSearchMockClient
import ai.systema.model.request.QueryItem
import ai.systema.model.request.SmartSearchRequest
import ai.systema.model.response.SmartSearchResponse
import ai.systema.testSuspend
import kotlin.test.Test
import kotlin.test.assertEquals
import kotlin.test.assertNotEquals
import kotlin.test.assertNull

internal open class SmartSearchImplTest : SmartSearchMockClient() {
    @Test
    fun testSmartSearch() = testSuspend {
        val connector = TestConfig.getConnector(this.initEngine())

        // check for failure
        val ep: EndpointSmartSearch = getEndpointSmartSearchFailureMock()
        var searcher: SmartSearch = SmartSearchImpl(connector, ep)
        var payload = SmartSearchRequest(
            query = listOf(QueryItem(id = "WSH10_White", type = QueryItemType.Product))
        )

        val resultError = searcher.smartSearch(payload)

        if (resultError.isSuccessful) {
            assertNull(resultError.value())
        } else {
            assertEquals(SystemaApiException::class, resultError.error()::class)
            assertEquals("API error occurred", resultError.error().message)
        }

        // check for success
        payload = SmartSearchRequest(
            query = listOf(QueryItem(id = "WSH10_White", type = QueryItemType.Product))
        )
        searcher = SmartSearch(connector)
        val resultSuccess = searcher.smartSearch(payload)

        if (resultSuccess.isSuccessful) {
            assertNotEquals(0, resultSuccess.value().results.size)
            this.checkSmartSearchResponse(resultSuccess.value())
        } else {
            throw IllegalStateException("Should not error", resultSuccess.error())
        }
    }

    @Test
    fun testSmartSearchWithCallback() = testSuspend {
        val connector = TestConfig.getConnector(this.initEngine())
        val searcher = SmartSearch(connector)
        val payload = SmartSearchRequest(
            query = listOf(QueryItem(id = "WSH10_White", type = QueryItemType.Product))
        )

        val resultSuccess = searcher.smartSearch(payload)

        if (resultSuccess.isSuccessful) {
            assertNotEquals(0, resultSuccess.value().results.size)
            this.checkSmartSearchResponse(resultSuccess.value())
        } else {
            throw IllegalStateException("Should not error", resultSuccess.error())
        }
    }

    /**
     * Return a mock that throws exception to allow us to test the failure scenarios
     */
    private fun getEndpointSmartSearchFailureMock(): EndpointSmartSearch {
        val ep: EndpointSmartSearch = object : EndpointSmartSearch {
            override suspend fun smartSearch(
                payload: SmartSearchRequest,
                requestOptions: RequestOptions
            ): SmartSearchResponse {
                throw SystemaApiException(IllegalArgumentException("test"))
            }
        }

        return ep
    }
}
