package ai.systema.model

import ai.systema.configuration.internal.SystemaInMemStorage
import ai.systema.constants.SystemaKeys
import ai.systema.testSuspend
import kotlinx.datetime.Clock
import kotlinx.datetime.Instant
import kotlin.test.Test
import kotlin.test.assertEquals
import kotlin.test.assertNotEquals
import kotlin.test.assertNotNull
import kotlin.test.assertNull
import kotlin.time.Duration.Companion.seconds
import kotlin.time.ExperimentalTime

internal class ClientUserTest {

    @OptIn(ExperimentalTime::class)
    @Test
    fun refreshSession() = testSuspend {
        val kvStore = SystemaInMemStorage()
        val now: Instant = Clock.System.now()
        val clientUser = ClientUser(fingerprint = "fid", maxIdleDuration = 3.seconds)

        var sid = kvStore.read(SystemaKeys.SessionId)
        assertNull(sid)
        clientUser.refreshSession(kvStore, now)
        sid = kvStore.read(SystemaKeys.SessionId)
        var sessionLastActivityAt = kvStore.read(SystemaKeys.SessionLastActivityAt)
        assertNotNull(sid)
        assertNotNull(sessionLastActivityAt)
        assertEquals(now.toString(), kvStore.read(SystemaKeys.SessionLastActivityAt))
        assertEquals(now.toString(), kvStore.read(SystemaKeys.SessionCreatedAt))

        // no change in session
        var now2 = now.plus(2.seconds)
        clientUser.refreshSession(kvStore, now2)
        assertEquals(sid, kvStore.read(SystemaKeys.SessionId)) // same as initial
        assertEquals(now.toString(), kvStore.read(SystemaKeys.SessionCreatedAt)) // same as initial
        assertEquals(now2.toString(), kvStore.read(SystemaKeys.SessionLastActivityAt)) // different to initial

        // new session after max IDLE
        now2 = now2.plus(4.seconds)
        clientUser.refreshSession(kvStore, now2)
        assertNotEquals(sid, kvStore.read(SystemaKeys.SessionId)) // different to initial
        assertEquals(now2.toString(), kvStore.read(SystemaKeys.SessionCreatedAt)) // different to initial
        assertEquals(now2.toString(), kvStore.read(SystemaKeys.SessionLastActivityAt)) // different to initial
    }
}
