package io.taskmonk.entities;

/**
 *
 * Returns a state for the batch. The supported state are:
 *<p>
 * "ACTIVE" - The batch is being worked on by the analysts
 *<p>
 * "PENDING" - Work has not started on the batch
 *<p>
 * "SCHEDULED" - A start time for the batch has been set and will be worked on after that date
 * <p></p>
 * "CANCELLED" - The execution of the batch has been cancelled by the customer
 * <p></p>
 * "COMPLETED" - Work on this batch has been compeleted
 */
public enum BatchState {
    PENDING,
    SCHEDULED,
    ACTIVE,
    CANCELLED,
    COMPLETED
}
