package io.taskmonk.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Date;

/**
 * Status of a batch
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class BatchStatus {
    /**
     * Number of tasks that are not started
     */
    Integer newCount;
    /**
     * Number of tasks in the batch that have been completed
     */
    Integer completed;

    /**
     * Number of tasks in the batch that were rejected due to missing mandatory fields
     */
    Integer rejected;

    /**
     * The total number of valid tasks in the batch
     */
    Integer total;

    /**
     * Specifies an estimate of when the batch is expected to be completed by the Annotation Partner.
     * This is optional and depends on the capacity of the annotation partner being set.
     * This can also be updated manually by the Annotation Partner The format is "YYYY-MM-DD"
     */
    Date eta;

    /**
     * Can be one of
     *
     * "Calculated" - If the eta is an approximate value that is calculated based on partner capacity
     *
     * "Manual" - If the eta has been set by the partner
     *
     */
    String etaType;
    /**
     * {@link BatchState}
     */
    BatchState state;
    public BatchStatus() {

    }
    public BatchStatus(Integer newCount, Integer inProgress, Integer completed, Integer total) {
        this.completed = completed;
        this.newCount = newCount;
        this.total = total;
    }

    @JsonProperty("new_count")
    public Integer getNewCount() {
        return newCount;
    }

    @JsonProperty("new_count")
    public void setNewCount(Integer newCount) {
        this.newCount = newCount;
    }


    public Integer getCompleted() {
        return completed;
    }

    public void setCompleted(Integer completed) {
        this.completed = completed;
    }

    public Integer getTotal() {
        return total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public Date getEta() {
        return eta;
    }

    public void setEta(Date eta) {
        this.eta = eta;
    }

    @JsonProperty("eta_type")
    public String getEtaType() {
        return etaType;
    }

    @JsonProperty("eta_type")
    public void setEtaType(String etaType) {
        this.etaType = etaType;
    }

    public BatchState getState() {
        return state;
    }

    public void setState(BatchState state) {
        this.state = state;
    }

    @Override
    public String toString() {
        return "completed = " + completed + "; total = " + total + "; state = " + state + "; eta = " + eta;
    }
}
