/*
 * Decompiled with CFR 0.152.
 */
package io.taskmonk.integrations.azure;

import com.microsoft.azure.servicebus.IMessage;
import com.microsoft.azure.servicebus.Message;
import com.microsoft.azure.servicebus.QueueClient;
import com.microsoft.azure.servicebus.ReceiveMode;
import com.microsoft.azure.servicebus.primitives.ConnectionStringBuilder;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceBusSendInterface {
    private static final Logger logger = LoggerFactory.getLogger(ServiceBusSendInterface.class);
    String queueName;
    String accessKey;
    String accessKeyName = "Client";
    String connectionString;

    public ServiceBusSendInterface(String queueName, String accessKey) {
        this.queueName = queueName;
        this.accessKey = accessKey;
        this.connectionString = String.format("Endpoint=sb://taskmonk.servicebus.windows.net/;SharedAccessKeyName=%s;SharedAccessKey=%s;EntityPath=%s", this.accessKeyName, accessKey, queueName);
    }

    public CompletableFuture<Void> send(String messageId, String label, String content) throws ServiceBusException, InterruptedException {
        QueueClient sendClient = new QueueClient(new ConnectionStringBuilder(this.connectionString, this.queueName), ReceiveMode.PEEKLOCK);
        Message message = new Message(content);
        message.setContentType("application/json");
        message.setLabel(label);
        message.setMessageId(messageId);
        message.setTimeToLive(Duration.ofDays(14L));
        logger.debug("\nMessage sending: Id = {}", (Object)message.getMessageId());
        return sendClient.sendAsync((IMessage)message);
    }
}

