/*
 * Decompiled with CFR 0.152.
 */
package io.taskmonk.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Task {
    static final Logger logger = LoggerFactory.getLogger(Task.class);
    public String batchId;
    public String externalId;
    public Map<String, String> data;

    public Task() {
    }

    public Task(String batchId, String externalId, Map<String, String> data, Boolean encode) {
        this.batchId = batchId;
        this.externalId = externalId;
        this.data = encode != false ? this.encodeData(data) : data;
    }

    public Task(String batchId, String externalId, Map<String, String> data) {
        this(batchId, externalId, data, true);
    }

    public Task(String externalId, Map<String, String> data) {
        this.externalId = externalId;
        this.data = data;
    }

    @JsonProperty(value="batch_id")
    public String getBatchId() {
        return this.batchId;
    }

    @JsonProperty(value="batch_id")
    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    @JsonProperty(value="external_id")
    public String getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="external_id")
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public void setData(Map<String, String> data) {
        this.data = data;
    }

    public String toString() {
        return "Task: " + this.batchId + " : " + this.externalId;
    }

    private Map<String, String> encodeData(Map<String, String> data) {
        HashMap<String, String> escapedData = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            try {
                escapedData.put(entry.getKey(), URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.toString()));
            }
            catch (UnsupportedEncodingException e) {
                logger.error(entry.getValue(), (Throwable)e);
            }
        }
        return escapedData;
    }
}

