/*
 * Decompiled with CFR 0.152.
 */
package io.taskmonk.auth;

import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenResponse {
    private static final Logger logger = LoggerFactory.getLogger(TokenResponse.class);
    String token_type;
    String access_token;
    String refresh_token;
    Long expires_in;
    LocalDateTime expires_at = LocalDateTime.now().minusDays(1L);

    public Boolean isExpired() {
        LocalDateTime now = LocalDateTime.now();
        logger.trace("now = {}; expires_at = {}", (Object)now, (Object)this.expires_at);
        if (now.isAfter(this.expires_at)) {
            return true;
        }
        return false;
    }

    public String getToken_type() {
        return this.token_type;
    }

    public void setToken_type(String token_type) {
        this.token_type = token_type;
    }

    public String getAccess_token() {
        return this.access_token;
    }

    public void setAccess_token(String access_token) {
        this.access_token = access_token;
    }

    public String getRefresh_token() {
        return this.refresh_token;
    }

    public void setRefresh_token(String refresh_token) {
        this.refresh_token = refresh_token;
    }

    public Long getExpires_in() {
        return this.expires_in;
    }

    public void setExpires_in(Long expires_in) {
        this.expires_in = expires_in;
        this.setExpiry();
    }

    public TokenResponse() {
    }

    public TokenResponse(String token_type, String access_token, String refresh_token, Long expires_in) {
        this.token_type = token_type;
        this.access_token = access_token;
        this.refresh_token = refresh_token;
        this.expires_in = expires_in;
        this.setExpiry();
    }

    private void setExpiry() {
        LocalDateTime now = LocalDateTime.now();
        this.expires_at = now.plusSeconds(this.expires_in - 30L);
    }

    public String toString() {
        return "access_token = " + this.access_token + "; refresh_token = {}" + this.refresh_token + "; expires_in = " + this.expires_in;
    }
}

