/*
 * Decompiled with CFR 0.152.
 */
package io.taskmonk.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.taskmonk.auth.OAuthClientCredentials;
import io.taskmonk.auth.TokenResponse;
import io.taskmonk.clientexceptions.ForbiddenException;
import io.taskmonk.clientexceptions.InternalServerError;
import io.taskmonk.clientexceptions.NotFoundException;
import io.taskmonk.clientexceptions.StatusConstants;
import io.taskmonk.clientexceptions.UnhandledException;
import io.taskmonk.entities.BatchOutput;
import io.taskmonk.entities.BatchStatus;
import io.taskmonk.entities.Id;
import io.taskmonk.entities.ImportUrl;
import io.taskmonk.entities.JobProgressResponse;
import io.taskmonk.entities.NewBatchData;
import io.taskmonk.entities.Notification;
import io.taskmonk.entities.Task;
import io.taskmonk.entities.TaskImportResponse;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Future;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskMonkClient {
    private static final Logger logger = LoggerFactory.getLogger(TaskMonkClient.class);
    HttpHost httpHost;
    HttpHost proxyHost;
    TokenResponse tokenResponse;
    String projectId;
    OAuthClientCredentials credentials;

    private TokenResponse refreshToken() throws Exception {
        URIBuilder builder = new URIBuilder(this.httpHost.toString() + "/api/oauth2/token").addParameter("grant_type", "client_credentials").addParameter("client_id", this.credentials.getClientId()).addParameter("client_secret", this.credentials.getClientSecret());
        HttpPost post = new HttpPost(builder.build());
        return this.invoke((HttpUriRequest)post, TokenResponse.class, false);
    }

    private TokenResponse getTokenResponse() throws Exception {
        if (this.tokenResponse == null || this.tokenResponse.isExpired().booleanValue()) {
            this.tokenResponse = this.refreshToken();
        }
        return this.tokenResponse;
    }

    private void downloadFile(String url, String localPath) throws Exception {
        ReadableByteChannel rbc = Channels.newChannel(new URL(url).openStream());
        FileOutputStream fos = new FileOutputStream(localPath);
        fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
    }

    private HttpPost getHttpPost(String path, List<NameValuePair> parameters, ContentType contentType) throws Exception {
        URIBuilder builder = new URIBuilder(this.httpHost.toString() + path);
        builder.addParameters(parameters);
        HttpPost post = new HttpPost(builder.build());
        post.addHeader("Content-type", contentType.toString());
        return post;
    }

    private HttpGet getHttpGet(String path) throws Exception {
        return this.getHttpGet(path, new ArrayList<NameValuePair>());
    }

    private HttpGet getHttpGet(String path, List<NameValuePair> parameters) throws Exception {
        URIBuilder builder = new URIBuilder(this.httpHost.toString() + path).addParameters(parameters);
        HttpGet get = new HttpGet(builder.build());
        return get;
    }

    public String createBatch(String batchName) throws Exception {
        URIBuilder builder = new URIBuilder(this.httpHost.toString() + "/api/project/" + this.projectId + "/batch");
        HttpPost post = new HttpPost(builder.build());
        post.addHeader("Content-type", "application/json");
        NewBatchData newBatchData = new NewBatchData(batchName);
        ObjectMapper mapper = new ObjectMapper();
        String body = mapper.writeValueAsString((Object)newBatchData);
        logger.trace("batch create content = {}", (Object)body);
        StringEntity stringEntity = new StringEntity(body);
        post.setEntity((HttpEntity)stringEntity);
        return this.invoke((HttpUriRequest)post, Id.class).id;
    }

    private <T> T invoke(HttpUriRequest request, Class<T> clazz) throws Exception {
        return this.invoke(request, clazz, true);
    }

    private <T> T invoke(HttpUriRequest request, Class<T> clazz, Boolean addAuthorization) throws Exception {
        if (addAuthorization.booleanValue()) {
            request.addHeader("Authorization", "Bearer " + this.getTokenResponse().getAccess_token());
        }
        CloseableHttpAsyncClient httpclient = HttpAsyncClients.custom().setProxy(this.proxyHost).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
        httpclient.start();
        Future httpResponse = httpclient.execute(request, null);
        logger.trace("Invoking : {} ", (Object)request);
        HttpResponse response = (HttpResponse)httpResponse.get();
        try {
            if (response.getStatusLine().getStatusCode() == StatusConstants.StatusCode.OK.getCode() || response.getStatusLine().getStatusCode() == StatusConstants.StatusCode.CREATED.getCode()) {
                String content = EntityUtils.toString((HttpEntity)response.getEntity());
                ObjectMapper mapper = new ObjectMapper();
                Object result = mapper.readValue(content, clazz);
                logger.trace("result {}", result);
                Object object = result;
                return (T)object;
            }
            throw this.handleException(response.getStatusLine().getStatusCode());
        }
        finally {
            httpclient.close();
        }
    }

    public String updateBatch(String batchId, String batchName, Short priority, String comments, List<Notification> notifications) throws Exception {
        URIBuilder builder = new URIBuilder(this.httpHost.toString() + "/api/project/" + this.projectId + "/batch/" + batchId);
        HttpPut put = new HttpPut(builder.build());
        put.addHeader("Content-type", "application/json");
        NewBatchData newBatchData = new NewBatchData(batchName);
        newBatchData.setComments(comments);
        newBatchData.setNotifications(notifications);
        newBatchData.setPriority(priority);
        ObjectMapper mapper = new ObjectMapper();
        String body = mapper.writeValueAsString((Object)newBatchData);
        logger.debug("update batch content {} ", (Object)body);
        StringEntity entity = new StringEntity(body);
        put.setEntity((HttpEntity)entity);
        return this.invoke((HttpUriRequest)put, Id.class).id;
    }

    public TaskImportResponse uploadTasks(String batchName, File file) throws Exception {
        logger.debug("Uploading tasks to batch {}", (Object)batchName);
        String batchId = this.createBatch(batchName);
        String path = file.getAbsolutePath();
        String fileType = FilenameUtils.getExtension((String)path);
        byte[] bytes = Files.readAllBytes(file.toPath());
        ByteArrayOutputStream arrOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream zipOutputStream = new GZIPOutputStream(arrOutputStream);
        zipOutputStream.write(bytes);
        zipOutputStream.close();
        arrOutputStream.close();
        byte[] output = arrOutputStream.toByteArray();
        String encoded = Base64.getEncoder().encodeToString(output);
        URIBuilder builder = new URIBuilder(this.httpHost.toString() + "/api/project/v2/" + this.projectId + "/batch/" + batchId + "/tasks/import");
        builder.addParameter("fileType", fileType);
        HttpPost post = new HttpPost(builder.build());
        StringEntity stringEntity = new StringEntity(encoded);
        post.setEntity((HttpEntity)stringEntity);
        TaskImportResponse result = this.invoke((HttpUriRequest)post, TaskImportResponse.class);
        logger.debug("Upload task id = {}", (Object)result.job_id);
        result.setBatch_id(batchId);
        return result;
    }

    public TaskImportResponse uploadTasksUrl(String batchName, String taskUrl, String fileType) throws Exception {
        String batchId = this.createBatch(batchName);
        URIBuilder builder = new URIBuilder(this.httpHost.toString() + "/api/project/" + this.projectId + "/batch/" + batchId + "/tasks/import/url");
        HttpPost post = new HttpPost(builder.build());
        post.addHeader("Content-type", "application/json");
        ImportUrl importUrl = new ImportUrl(taskUrl, fileType);
        ObjectMapper mapper = new ObjectMapper();
        StringEntity entity = new StringEntity(mapper.writeValueAsString((Object)importUrl));
        post.setEntity((HttpEntity)entity);
        TaskImportResponse result = this.invoke((HttpUriRequest)post, TaskImportResponse.class);
        result.setBatch_id(batchId);
        return result;
    }

    public TaskImportResponse uploadTasksToBatch(String batchId, File file) throws Exception {
        String path = file.getAbsolutePath();
        String fileType = FilenameUtils.getExtension((String)path);
        byte[] bytes = Files.readAllBytes(file.toPath());
        ByteArrayOutputStream arrOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream zipOutputStream = new GZIPOutputStream(arrOutputStream);
        zipOutputStream.write(bytes);
        zipOutputStream.close();
        arrOutputStream.close();
        byte[] output = arrOutputStream.toByteArray();
        String encoded = Base64.getEncoder().encodeToString(output);
        URIBuilder builder = new URIBuilder(this.httpHost.toString() + "/api/project/" + this.projectId + "/batch/" + batchId + "/tasks/import");
        builder.addParameter("fileType", fileType);
        HttpPost post = new HttpPost(builder.build());
        StringEntity stringEntity = new StringEntity(encoded);
        post.setEntity((HttpEntity)stringEntity);
        TaskImportResponse result = this.invoke((HttpUriRequest)post, TaskImportResponse.class);
        logger.debug("Task upload job id = {}", (Object)result.job_id);
        return result;
    }

    public TaskImportResponse uploadTasksUrlToBatch(String batchId, String taskUrl, String fileType) throws Exception {
        URIBuilder builder = new URIBuilder(this.httpHost.toString() + "/api/project/" + this.projectId + "/batch/" + batchId + "/tasks/import/url");
        HttpPost post = new HttpPost(builder.build());
        post.addHeader("Content-type", "application/json");
        ObjectMapper mapper = new ObjectMapper();
        ImportUrl importUrl = new ImportUrl(taskUrl, fileType);
        StringEntity entity = new StringEntity(mapper.writeValueAsString((Object)importUrl));
        post.setEntity((HttpEntity)entity);
        return this.invoke((HttpUriRequest)post, TaskImportResponse.class);
    }

    public String addTask(Task task) throws Exception {
        URIBuilder builder = new URIBuilder(this.httpHost.toString() + "/api/project/" + this.projectId + "/task/external");
        ObjectMapper mapper = new ObjectMapper();
        String body = mapper.writeValueAsString((Object)task);
        StringEntity entity = new StringEntity(body);
        HttpPost post = new HttpPost(builder.build());
        post.addHeader("Content-type", "application/json");
        post.setEntity((HttpEntity)entity);
        return this.invoke((HttpUriRequest)post, Id.class).id;
    }

    private void waitForCompletion(String jobId) throws Exception {
        JobProgressResponse jobProgressResponse = this.getJobProgress(jobId);
        while (!jobProgressResponse.isCompleted().booleanValue()) {
            Thread.sleep(5000L);
            jobProgressResponse = this.getJobProgress(jobId);
        }
    }

    public void getBatchOutput(String batchId, String outputFormat, String outputPath) throws Exception {
        String url = "/api/project/v2/" + this.projectId + "/batch/" + batchId + "/output";
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("output_format", outputFormat));
        HashMap fieldNames = new HashMap();
        fieldNames.put("field_names", new ArrayList());
        ObjectMapper mapper = new ObjectMapper();
        String content = mapper.writeValueAsString(fieldNames);
        HttpPost post = this.getHttpPost(url, parameters, ContentType.APPLICATION_JSON);
        post.setEntity((HttpEntity)new StringEntity(content));
        BatchOutput batchOutput = this.invoke((HttpUriRequest)post, BatchOutput.class);
        this.waitForCompletion(batchOutput.getjob_id());
        this.downloadFile(batchOutput.getfile_url(), outputPath);
    }

    private Exception handleException(int statusCode) {
        logger.error("status code = {}", (Object)statusCode);
        if (StatusConstants.StatusCode.FORBIDDEN.getCode() == statusCode) {
            return new ForbiddenException(StatusConstants.StatusCode.FORBIDDEN.getDisplay());
        }
        if (StatusConstants.StatusCode.INTERNALSERVERERROR.getCode() == statusCode) {
            return new InternalServerError(StatusConstants.StatusCode.INTERNALSERVERERROR.getDisplay());
        }
        if (StatusConstants.StatusCode.NOTFOUND.getCode() == statusCode) {
            return new NotFoundException(StatusConstants.StatusCode.NOTFOUND.getDisplay());
        }
        return new UnhandledException("Got status code : " + statusCode);
    }

    public JobProgressResponse getJobProgress(String jobId) throws Exception {
        String url = "/api/project/" + this.projectId + "/job/" + jobId + "/status";
        HttpGet httpGet = this.getHttpGet(url);
        JobProgressResponse getResponse = this.invoke((HttpUriRequest)httpGet, JobProgressResponse.class);
        return getResponse;
    }

    public JobProgressResponse getJobProgressBatch(String batchId) throws Exception {
        String url = "/api/project/" + this.projectId + "/job/" + batchId + "/status";
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("input_type", "batch"));
        HttpGet httpGet = this.getHttpGet(url, parameters);
        JobProgressResponse getResponse = this.invoke((HttpUriRequest)httpGet, JobProgressResponse.class);
        return getResponse;
    }

    public BatchStatus getBatchStatus(String batchId) throws Exception {
        String url = "/api/project/v2/" + this.projectId + "/batch/" + batchId + "/status";
        HttpGet httpGet = this.getHttpGet(url);
        BatchStatus getResponse = this.invoke((HttpUriRequest)httpGet, BatchStatus.class);
        return getResponse;
    }

    public Boolean isProcessComplete(String batchId) throws Exception {
        BatchStatus batchStatus = this.getBatchStatus(batchId);
        return batchStatus.getCompleted().equals(batchStatus.getTotal());
    }

    public Boolean isUploadComplete(String batchId) throws Exception {
        JobProgressResponse jobResponse = this.getJobProgressBatch(batchId);
        return jobResponse.isCompleted();
    }

    public TaskMonkClient(String projectId, String server, OAuthClientCredentials credentials) {
        this.projectId = projectId;
        this.credentials = credentials;
        this.httpHost = HttpHost.create((String)server);
    }

    public TaskMonkClient(String projectId, String server, String proxy, OAuthClientCredentials credentials) {
        this.projectId = projectId;
        this.credentials = credentials;
        this.httpHost = HttpHost.create((String)server);
        if (proxy != null) {
            this.proxyHost = HttpHost.create((String)proxy);
        }
    }
}

