/*
 * Decompiled with CFR 0.152.
 */
package ai.tecton.client.response;

import ai.tecton.client.exceptions.TectonClientException;
import ai.tecton.client.exceptions.TectonServiceException;
import ai.tecton.client.model.FeatureValue;
import ai.tecton.client.model.SloInformation;
import ai.tecton.client.response.AbstractTectonResponse;
import ai.tecton.client.response.GetFeaturesResponse;
import ai.tecton.client.response.GetFeaturesResponseUtils;
import ai.tecton.client.transport.HttpResponse;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class GetFeaturesBatchResponse {
    private final List<GetFeaturesResponse> batchResponseList;
    private SloInformation batchSloInfo;
    private Duration requestLatency;
    private static JsonAdapter<GetFeaturesMicroBatchResponse.GetFeaturesBatchResponseJson> jsonAdapter;

    public GetFeaturesBatchResponse(List<HttpResponse> httpResponseList, Duration totalDuration, int microBatchSize) {
        Moshi moshi = new Moshi.Builder().build();
        jsonAdapter = moshi.adapter(GetFeaturesMicroBatchResponse.GetFeaturesBatchResponseJson.class);
        List microBatchResponses = httpResponseList.parallelStream().map(httpResponse -> this.parseSingleHttpResponse((HttpResponse)httpResponse, microBatchSize)).collect(Collectors.toList());
        this.batchResponseList = microBatchResponses.parallelStream().map(microBatch -> ((GetFeaturesMicroBatchResponse)microBatch).microBatchResponseList).flatMap(Collection::stream).collect(Collectors.toList());
        List<SloInformation> microBatchSloInfoList = microBatchResponses.stream().filter(microBatchResponse -> microBatchResponse.getMicroBatchSloInformation().isPresent()).map(microBatchResponse -> microBatchResponse.getMicroBatchSloInformation().get()).collect(Collectors.toList());
        if (!microBatchSloInfoList.isEmpty()) {
            this.batchSloInfo = this.computeBatchSloInfo(microBatchSloInfoList);
        }
        this.requestLatency = totalDuration;
    }

    public List<GetFeaturesResponse> getBatchResponseList() {
        return this.batchResponseList;
    }

    public Duration getRequestLatency() {
        return this.requestLatency;
    }

    public Optional<SloInformation> getBatchSloInformation() {
        return Optional.ofNullable(this.batchSloInfo);
    }

    private GetFeaturesMicroBatchResponse parseSingleHttpResponse(HttpResponse httpResponse, int microBatchSize) {
        if (httpResponse == null) {
            return new GetFeaturesMicroBatchResponse(Collections.nCopies(microBatchSize, null), null);
        }
        if (!httpResponse.isSuccessful()) {
            throw new TectonServiceException(String.format("Received Error Response from Tecton wih code %s and error message: %s", httpResponse.getResponseCode(), httpResponse.getMessage()));
        }
        if (!httpResponse.getResponseBody().isPresent()) {
            throw new TectonClientException("Received empty response body from Tecton");
        }
        String responseJson = httpResponse.getResponseBody().get();
        if (microBatchSize == 1) {
            return new GetFeaturesMicroBatchResponse(Collections.singletonList(new GetFeaturesResponse(responseJson, httpResponse.getRequestDuration())), null);
        }
        return new GetFeaturesMicroBatchResponse(responseJson, httpResponse.getRequestDuration());
    }

    private static GetFeaturesResponse generateGetFeaturesResponse(List<GetFeaturesResponseUtils.FeatureVectorJson> featureVectorJson, List<GetFeaturesResponseUtils.FeatureMetadata> featureMetadata, List<SloInformation> sloInformationList, Duration requestLatency, int index) {
        List<FeatureValue> featureValues = GetFeaturesResponseUtils.constructFeatureVector(featureVectorJson.get((int)index).features, featureMetadata, index);
        GetFeaturesResponse getFeaturesResponse = new GetFeaturesResponse(featureValues, requestLatency);
        if (sloInformationList != null) {
            getFeaturesResponse.setSloInformation(sloInformationList.get(index));
        }
        return getFeaturesResponse;
    }

    SloInformation computeBatchSloInfo(List<SloInformation> batchSloInformation) {
        batchSloInformation.removeAll(Collections.singleton(null));
        boolean isSloEligibleBatch = batchSloInformation.stream().noneMatch(sloInfo -> sloInfo.isSloEligible().isPresent() && sloInfo.isSloEligible().get() == false);
        Double maxSloServerTimeSeconds = this.getMaxValueFromOptionalList(batchSloInformation.stream().map(SloInformation::getSloServerTimeSeconds).collect(Collectors.toList()));
        Double storeMaxLatency = this.getMaxValueFromOptionalList(batchSloInformation.stream().map(SloInformation::getStoreMaxLatency).collect(Collectors.toList()));
        Double maxServerTimeSeconds = this.getMaxValueFromOptionalList(batchSloInformation.stream().map(SloInformation::getServerTimeSeconds).collect(Collectors.toList()));
        Set<SloInformation.SloIneligibilityReason> sloIneligibilityReasons = batchSloInformation.stream().map(SloInformation::getSloIneligibilityReasons).flatMap(Collection::stream).collect(Collectors.toSet());
        return new SloInformation.Builder().isSloEligible(isSloEligibleBatch).serverTimeSeconds(maxServerTimeSeconds).sloServerTimeSeconds(maxSloServerTimeSeconds).sloIneligibilityReasons(sloIneligibilityReasons).storeMaxLatency(storeMaxLatency).build();
    }

    private Double getMaxValueFromOptionalList(List<Optional<Double>> values) {
        OptionalDouble doubleVal = values.stream().filter(Optional::isPresent).mapToDouble(Optional::get).max();
        return doubleVal.isPresent() ? Double.valueOf(doubleVal.getAsDouble()) : null;
    }

    private static class GetFeaturesMicroBatchResponse
    extends AbstractTectonResponse {
        private List<GetFeaturesResponse> microBatchResponseList;
        private SloInformation microBatchSloInfo;

        GetFeaturesMicroBatchResponse(String response, Duration requestLatency) {
            super(requestLatency);
            this.buildResponseFromJson(response);
        }

        GetFeaturesMicroBatchResponse(List<GetFeaturesResponse> microBatchResponseList, Duration requestDuration) {
            super(requestDuration);
            this.microBatchResponseList = microBatchResponseList;
        }

        Optional<SloInformation> getMicroBatchSloInformation() {
            return Optional.ofNullable(this.microBatchSloInfo);
        }

        @Override
        void buildResponseFromJson(String response) {
            if (response != null) {
                GetFeaturesBatchResponseJson responseJson;
                try {
                    responseJson = (GetFeaturesBatchResponseJson)jsonAdapter.fromJson(response);
                }
                catch (IOException e) {
                    throw new TectonClientException("Unable to parse JSON response from Tecton");
                }
                List<GetFeaturesResponseUtils.FeatureVectorJson> featureVectorJson = responseJson.result;
                List<GetFeaturesResponseUtils.FeatureMetadata> featureMetadata = responseJson.metadata.features;
                List<SloInformation> sloInformationList = responseJson.metadata.sloInfo;
                this.microBatchResponseList = IntStream.range(0, responseJson.result.size()).parallel().mapToObj(i -> GetFeaturesBatchResponse.generateGetFeaturesResponse(featureVectorJson, featureMetadata, sloInformationList, this.getRequestLatency(), i)).collect(Collectors.toList());
                this.microBatchSloInfo = responseJson.metadata.batchSloInfo;
            }
        }

        static class GetFeaturesBatchResponseJson {
            List<GetFeaturesResponseUtils.FeatureVectorJson> result;
            ResponseMetadataJson metadata;

            GetFeaturesBatchResponseJson() {
            }

            static class ResponseMetadataJson {
                List<GetFeaturesResponseUtils.FeatureMetadata> features;
                List<SloInformation> sloInfo;
                SloInformation batchSloInfo;

                ResponseMetadataJson() {
                }
            }
        }
    }
}

