package com.particles.facebookadapter

import org.json.JSONException
import org.json.JSONObject
import org.prebid.mobile.rendering.bidding.data.bid.Bid

class FacebookBid(private val bid: Bid, private val currency: String?) : com.facebook.biddingkit.gen.Bid {

    private var adm: JSONObject? = null

    init {
        try {
            adm = JSONObject(bid.adm)
        } catch (ignored: JSONException) {}
    }

    override fun getPrice(): Double {
        return bid.price
    }

    override fun getBidderName(): String {
        return MSP_BIDDER_FB
    }

    override fun getPlacementId(): String? {
        adm?.let {
            return if (!it.optString("resolved_placement_id").isNullOrEmpty())
                it.optString("resolved_placement_id")
            else
                it.optString("placement_id")
        } ?: return null
    }

    override fun getPayload(): String {
        return bid.adm
    }

    override fun getCurrency(): String? {
        return currency
    }

    companion object {
        private const val MSP_BIDDER_FB = "audienceNetwork"
    }
}