package com.particles.facebookadapter

import android.content.Context
import com.facebook.ads.BidderTokenProvider.getBidderToken
import com.particles.msp.adapter.FacebookBidTokenListener
import com.particles.msp.adapter.FacebookBidTokenProvider
import com.particles.msp.util.Logger
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlin.system.measureTimeMillis

class FacebookBidTokenProviderImp: FacebookBidTokenProvider {
    override fun fetch(completeListener: FacebookBidTokenListener, context: Any) {
        var facebookBidToken = ""
        if (context is Context) {
            CoroutineScope(Dispatchers.IO).launch {
                val timeTakenFBToken = measureTimeMillis {
                    facebookBidToken = getBidderToken(context)
                    Logger.info("Got Facebook token: $facebookBidToken")
                }
                Logger.info("Time spent getting fb token: $timeTakenFBToken")
                completeListener.onComplete(facebookBidToken)
            }
        }
    }
}