package com.particles.inmobiadapter

import android.content.Context
import android.util.AttributeSet
import android.widget.FrameLayout
import com.inmobi.ads.InMobiNative

class InMobiMediaView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : FrameLayout(context, attrs, defStyleAttr) {

    private var ad: InMobiNative? = null

    fun setNativeAd(ad: InMobiNative) {
        this.ad = ad
        render()
    }

    override fun onLayout(changed: Boolean, left: Int, top: Int, right: Int, bottom: Int) {
        super.onLayout(changed, left, top, right, bottom)
        if (changed) {
            render()
        }
    }

    private fun render() {
        removeAllViewsInLayout()
        if (width <= 0) return
        ad?.getPrimaryViewOfWidth(context, this, this, width)?.let { addView(it) }
    }
}
