package com.particles.mes.android.data.mapper

import org.prebid.mobile.ContentObject
import com.particles.mes.protos.openrtb.BidRequest as BidRequestProto
import org.prebid.mobile.rendering.models.openrtb.BidRequest as MspBidRequest
import org.prebid.mobile.rendering.models.openrtb.bidRequests.App
import org.prebid.mobile.rendering.models.openrtb.bidRequests.Device
import org.prebid.mobile.rendering.models.openrtb.bidRequests.Imp
import org.prebid.mobile.rendering.models.openrtb.bidRequests.Regs
import org.prebid.mobile.rendering.models.openrtb.bidRequests.User
import org.prebid.mobile.rendering.models.openrtb.bidRequests.apps.Publisher
import org.prebid.mobile.rendering.models.openrtb.bidRequests.source.Source

object BidRequestMapper {

    fun map(source: MspBidRequest): BidRequestProto {
        return BidRequestProto.newBuilder()
            .apply {
                id = source.id
//                app = map(source.app)
//                source.imp.forEach { addImp(map(it)) }
//                regs = map(source.regs)
//                user = map(source.user)
//                this.source = map(source.source)
                device = map(source.device)
            }
            .build()
    }

    // App
    private fun map(source: App): BidRequestProto.App {
        return BidRequestProto.App.newBuilder()
            .apply {
                id = source.id
                name = source.name
                domain = source.domain
                source.cat?.forEach { addCat(it) }
                source.sectioncat?.forEach { addSectioncat(it) }
                source.pagecat?.forEach { addPagecat(it) }
                ver = source.ver
                bundle = source.bundle
                privacypolicy = source.privacypolicy != 0
                paid = source.paid != 0
                publisher = map(source.publisher)
                content = source.contentObject?.let { map(it) }
                keywords = source.keywords
                storeurl = source.storeurl
            }
            .build()
    }

    private fun map(source: Publisher): BidRequestProto.Publisher {
        return BidRequestProto.Publisher.newBuilder()
            .apply {
                id = source.id
                name = source.name
                source.cat?.forEach { addCat(it) }
                domain = source.domain
            }
            .build()
    }

    private fun map(source: ContentObject): BidRequestProto.Content {
        return BidRequestProto.Content.newBuilder()
            .apply {
                id = source.id
            }
            .build()
    }

    // Device
    private fun map(source: Device): BidRequestProto.Device {
        return BidRequestProto.Device.newBuilder().apply {
            source.getGeo().country?.let {
                geo = BidRequestProto.Geo.newBuilder()
                    .setCountry(it)
                    .build()
            }
        }
            .build()
    }

    // Imp
    private fun map(source: Imp): BidRequestProto.Imp {
        return BidRequestProto.Imp.newBuilder()
            .build()
    }

    // Regs
    private fun map(source: Regs): BidRequestProto.Regs {
        return BidRequestProto.Regs.newBuilder()
            .build()
    }

    // User
    private fun map(source: User): BidRequestProto.User {
        return BidRequestProto.User.newBuilder()
            .build()
    }

    // Source
    private fun map(source: Source): BidRequestProto.Source {
        return BidRequestProto.Source.newBuilder()
            .build()
    }
}
