package com.particles.msp.api

import android.content.Context
import com.particles.msp.MSPManager
import java.util.UUID

data class AdSize (
    val width: Int,
    val height: Int,
    val isInlineAdaptiveBanner: Boolean,
    val isAnchorAdaptiveBanner: Boolean
)

class AdRequest(
    val customParams: Map<String, Any>,
    val geo: Geo?,
    val context: Context,
    val adaptiveBannerSize: AdSize?,
    val adSize: AdSize?,
    val placementId: String,
    var adFormat: AdFormat,
    val testParams: Map<String, Any>,
    val org: String = "",
    val app: String = "",
    val uuid: String = UUID.randomUUID().toString()
) {
    class Builder(val adFormat: AdFormat) {
        private var customParams: MutableMap<String, Any> = mutableMapOf()
        private var geo: Geo? = null
        private lateinit var context: Context
        private var adaptiveBannerSize: AdSize? = null
        private var adSize: AdSize? = null
        private lateinit var placementId: String
        private var testParams: MutableMap<String, Any> = mutableMapOf()

        fun addCustomParam(key: String, value: Any): Builder = apply { customParams[key] = value }
        fun setCustomParams(params: Map<String, Any>): Builder = apply { customParams =  params.toMutableMap()}
        fun setGeoLocation(geo: Geo): Builder = apply { this.geo = geo }
        fun setContext(context: Context): Builder = apply { this.context = context}
        fun setAdaptiveBannerSize(adSize: AdSize): Builder = apply { this.adaptiveBannerSize = adSize }
        fun setAdSize(adSize: AdSize): Builder = apply { this.adSize = adSize }
        fun setPlacement(placementId: String): Builder = apply { this.placementId = placementId }
        fun setTestParams(testParams: Map<String, Any>): Builder = apply { this.testParams = testParams.toMutableMap()}
        fun build(): AdRequest = AdRequest(customParams, geo, context, adaptiveBannerSize, adSize, placementId, adFormat, testParams, MSPManager.org, MSPManager.app)
    }
}