package com.particles.msp.auction

import com.particles.msp.MSPManager
import com.particles.msp.adapter.AdNetwork
import com.particles.msp.api.AdFormat
import com.particles.msp.api.AdListener
import com.particles.msp.api.AdRequest
import com.particles.msp.util.Logger

class DefaultBidder(private val bidderInfo: BidderInfo) : Bidder(bidderInfo) {

    private val network = AdNetwork.entries.firstOrNull {
        it.name.equals(bidderInfo.name, true)
    }

    override fun requestBid(adRequest: AdRequest, bidListener: AuctionBidListener, adListener: AdListener) {
        if (network == null) {
            Logger.info("[DefaultBidder] cannot find the ad network for bidder: ${bidderInfo.name}")
            bidListener.onError("cannot find the ad network for bidder: ${bidderInfo.name}")
            return
        }

        val adapter = MSPManager.adNetworkAdapterProvider?.getAdNetworkAdapter(network)
        if (adapter == null) {
            Logger.info("[DefaultBidder] ad network adapter is null for network: $network")
            bidListener.onError("ad network adapter is null for network: $network")
            return
        }

        val newAdRequest = if (adRequest.adFormat == AdFormat.MULTI_FORMAT) {
            when (bidderInfo.bidderFormat?.lowercase()) {
                "banner" -> adRequest.adFormat = AdFormat.BANNER
                "native" -> adRequest.adFormat = AdFormat.NATIVE
            }
            adRequest
        } else adRequest

        Logger.info("[Bidder: $network] send bid request for bidderPlacementId: $bidderPlacementId")
        adapter.loadAdCreative(null, bidListener, adRequest.context, newAdRequest, adListener, bidderPlacementId, bidderInfo)
    }
}
