package com.particles.msp.util
import android.content.Context
import com.google.android.gms.ads.identifier.AdvertisingIdClient
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext

suspend fun getAdvertisingId(context: Context): String? = withContext(Dispatchers.IO) {
    try {
        val adInfo = AdvertisingIdClient.getAdvertisingIdInfo(context)
        if (!adInfo.isLimitAdTrackingEnabled) {
            adInfo.id // Returns the Ad ID if tracking is not limited
        } else {
            null // Ad ID is restricted due to user's limit ad tracking preference
        }
    } catch (e: Exception) {
        e.printStackTrace()
        null // Handle any errors, e.g., if Google Play Services is unavailable
    }
}