package com.particles.msp.api

import com.particles.msp.adapter.AdNetworkAdapter

abstract class NativeAd(adNetworkAdapter: AdNetworkAdapter, builder: Builder) : MSPAd(adNetworkAdapter) {
    val title: String = builder.title
    val body: String = builder.body
    val advertiser: String = builder.advertiser
    val callToAction: String = builder.callToAction
    val optionsView: Any? = builder.optionsView
    val mediaView: Any? = builder.mediaView
    val mediaController: MediaController? = builder.mediaController
    var nativeAdView: Any? = null

    abstract fun prepareViewForInteraction(nativeAdView: Any)
    abstract class Builder(private val adNetworkAdapter: AdNetworkAdapter) {
        var title: String = ""
        var body: String = ""
        var advertiser: String = ""
        var callToAction: String = ""
        var optionsView:Any? = null
        var mediaView:Any? = null
        var mediaController: MediaController? = null

        fun title(title: String) = apply { this.title = title }
        fun body(body: String) = apply { this.body = body }
        fun advertiser(advertiser: String) = apply { this.advertiser = advertiser }
        fun callToAction(callToAction: String) = apply { this.callToAction = callToAction }
        fun optionsView(optionsView: Any) = apply { this.optionsView = optionsView }
        fun mediaView(mediaView: Any) = apply { this.mediaView = mediaView }
        fun mediaController(mediaController: MediaController) = apply {
            this.mediaController = mediaController
        }

        abstract fun build(): NativeAd
    }
}