package com.particles.msp.adapter

import com.particles.msp.AdCache
import com.particles.msp.api.AdListener
import com.particles.msp.api.AdRequest
import com.particles.msp.api.MSPAd
import com.particles.msp.api.NativeAd
import com.particles.msp.util.Logger

abstract class AdNetworkAdapter {
    protected var mspAd: MSPAd? = null
    abstract fun loadAdCreative(bidResponse: Any, adListener: AdListener, context: Any, adRequest: AdRequest)
    abstract fun initialize(
        initParams: InitializationParameters,
        adapterInitListener: AdapterInitListener,
        context: Any? = null)
    abstract fun destroyAd()
    abstract fun prepareViewForInteraction(nativeAd: NativeAd, nativeAdView: Any)

    fun handleAdLoaded(ad: MSPAd, listener: AdListener, adRequest: AdRequest) {
        mspAd = ad
        if (adRequest.isCacheSupported)  {
            Logger.info("save Ad to cache: ${adRequest.placementId}")
            AdCache.saveAd(adRequest.placementId, ad)
            Logger.info("notify listener ad is loaded. placementId: ${adRequest.placementId}")
            listener.onAdLoaded(adRequest.placementId)
        } else {
            Logger.info("invoke callback onAdLoaded with ad. placementId: ${adRequest.placementId}")
            listener.onAdLoaded(ad)
        }
    }

    fun handleAdClicked(listener: AdListener, adRequest: AdRequest) {
        mspAd?.let {
            Logger.info("notify listener ad is clicked. placementId: ${adRequest.placementId}")
            listener.onAdClicked(it)
        }
    }

    fun handleAdDismissed(listener: AdListener, adRequest: AdRequest) {
        mspAd?.let {
            Logger.info("notify listener ad is dismissed. placementId: ${adRequest.placementId}")
            listener.onAdDismissed(it)
        }
    }

    fun handleAdImpression(listener: AdListener, adRequest: AdRequest) {
        mspAd?.let {
            Logger.info("notify listener ad is displayed. placementId: ${adRequest.placementId}")
            listener.onAdImpression(it)
        }
    }
}