package com.particles.msp.api

data class AdSize (
    val width: Int,
    val height: Int,
    val isInlineAdaptiveBanner: Boolean,
    val isAnchorAdaptiveBanner: Boolean
)

data class AdRequest(
    val customParams: Map<String, Any>,
    val geo: Geo?,
    val context: Any?,
    val adaptiveBannerSize: AdSize?,
    val adSize: AdSize?,
    val placementId: String,
    val adFormat: AdFormat,
    val isCacheSupported: Boolean,
    val testParams: Map<String, Any>
) {
    class Builder(val adFormat: AdFormat) {
        private var customParams: MutableMap<String, Any> = mutableMapOf()
        private var geo: Geo? = null
        private var context: Any? = null
        private var adaptiveBannerSize: AdSize? = null
        private var adSize: AdSize? = null
        private lateinit var placementId: String
        private var isCacheSupported: Boolean = false
        private var testParams: MutableMap<String, Any> = mutableMapOf()

        fun addCustomParam(key: String, value: Any): Builder = apply { customParams[key] = value }
        fun setCustomParams(params: Map<String, Any>): Builder = apply { customParams =  params.toMutableMap()}
        fun setGeoLocation(geo: Geo): Builder = apply { this.geo = geo }
        fun setContext(context: Any): Builder = apply { this.context = context}
        fun setAdaptiveBannerSize(adSize: AdSize): Builder = apply { this.adaptiveBannerSize = adSize }
        fun setAdSize(adSize: AdSize): Builder = apply { this.adSize = adSize }
        fun setPlacement(placementId: String): Builder = apply { this.placementId = placementId }
        fun setIsCacheSupported(isCacheSupported: Boolean): Builder = apply { this.isCacheSupported = isCacheSupported }
        fun setTestParams(testParams: Map<String, Any>): Builder = apply { this.testParams = testParams.toMutableMap()}
        fun build(): AdRequest = AdRequest(customParams, geo, context, adaptiveBannerSize, adSize, placementId, adFormat, isCacheSupported, testParams)
    }
}