/*
 * Decompiled with CFR 0.152.
 */
package com.particles.msp.api;

import com.particles.msp.AdCache;
import com.particles.msp.AdNetworkAdapterProvider;
import com.particles.msp.BidListener;
import com.particles.msp.BidLoader;
import com.particles.msp.BidLoaderProvider;
import com.particles.msp.MSPManager;
import com.particles.msp.adapter.AdNetwork;
import com.particles.msp.adapter.AdNetworkAdapter;
import com.particles.msp.api.AdListener;
import com.particles.msp.api.AdLoader;
import com.particles.msp.api.AdRequest;
import com.particles.msp.api.MSPAd;
import com.particles.msp.util.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/particles/msp/api/AdLoader;", "", "()V", "adNetworkAdapter", "Lcom/particles/msp/adapter/AdNetworkAdapter;", "getAdNetworkAdapter", "()Lcom/particles/msp/adapter/AdNetworkAdapter;", "setAdNetworkAdapter", "(Lcom/particles/msp/adapter/AdNetworkAdapter;)V", "bidLoader", "Lcom/particles/msp/BidLoader;", "getBidLoader", "()Lcom/particles/msp/BidLoader;", "setBidLoader", "(Lcom/particles/msp/BidLoader;)V", "loadAd", "", "placementId", "", "adListener", "Lcom/particles/msp/api/AdListener;", "context", "adRequest", "Lcom/particles/msp/api/AdRequest;", "msp-core_release"})
public final class AdLoader {
    @Nullable
    private BidLoader bidLoader;
    @Nullable
    private AdNetworkAdapter adNetworkAdapter;

    @Nullable
    public final BidLoader getBidLoader() {
        return this.bidLoader;
    }

    public final void setBidLoader(@Nullable BidLoader bidLoader) {
        this.bidLoader = bidLoader;
    }

    @Nullable
    public final AdNetworkAdapter getAdNetworkAdapter() {
        return this.adNetworkAdapter;
    }

    public final void setAdNetworkAdapter(@Nullable AdNetworkAdapter adNetworkAdapter) {
        this.adNetworkAdapter = adNetworkAdapter;
    }

    public final void loadAd(@NotNull String placementId, @NotNull AdListener adListener, @NotNull Object context, @NotNull AdRequest adRequest) {
        Intrinsics.checkNotNullParameter((Object)placementId, (String)"placementId");
        Intrinsics.checkNotNullParameter((Object)adListener, (String)"adListener");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)adRequest, (String)"adRequest");
        long start = System.currentTimeMillis();
        if (adRequest.isCacheSupported()) {
            MSPAd cachedAd = AdCache.INSTANCE.peakAd(placementId);
            if (cachedAd != null) {
                MSPAd it = cachedAd;
                boolean bl = false;
                adListener.onAdLoaded(adRequest.getPlacementId());
                return;
            }
            Logger.INSTANCE.info("loadAd() time latency: " + (System.currentTimeMillis() - start) + " ms");
        }
        BidLoaderProvider bidLoaderProvider = MSPManager.INSTANCE.getBidLoaderProvider();
        this.bidLoader = bidLoaderProvider != null ? bidLoaderProvider.getBidLoader() : null;
        Logger.INSTANCE.info("Sending bid request.... " + placementId);
        BidLoader bidLoader = this.bidLoader;
        if (bidLoader != null) {
            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000'\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"com/particles/msp/api/AdLoader$loadAd$BidListenerImp", "Lcom/particles/msp/BidListener;", "(Ljava/lang/String;Lcom/particles/msp/api/AdLoader;Lcom/particles/msp/api/AdListener;Ljava/lang/Object;Lcom/particles/msp/api/AdRequest;)V", "onBidResponse", "", "bidResponse", "", "adNetwork", "Lcom/particles/msp/adapter/AdNetwork;", "onError", "msg", "", "msp-core_release"})
            public final class BidListenerImp
            implements BidListener {
                final /* synthetic */ String $placementId;
                final /* synthetic */ AdLoader this$0;
                final /* synthetic */ AdListener $adListener;
                final /* synthetic */ Object $context;
                final /* synthetic */ AdRequest $adRequest;

                public BidListenerImp(@NotNull String $placementId, @NotNull AdLoader $receiver, @NotNull AdListener $adListener, @NotNull Object $context, @NotNull AdRequest $adRequest) {
                    Intrinsics.checkNotNullParameter((Object)$placementId, (String)"$placementId");
                    Intrinsics.checkNotNullParameter((Object)$receiver, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$adListener, (String)"$adListener");
                    Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
                    Intrinsics.checkNotNullParameter((Object)$adRequest, (String)"$adRequest");
                    this.$placementId = $placementId;
                    this.this$0 = $receiver;
                    this.$adListener = $adListener;
                    this.$context = $context;
                    this.$adRequest = $adRequest;
                }

                public void onBidResponse(@NotNull Object bidResponse, @NotNull AdNetwork adNetwork) {
                    block2: {
                        Unit unit;
                        Intrinsics.checkNotNullParameter((Object)bidResponse, (String)"bidResponse");
                        Intrinsics.checkNotNullParameter((Object)((Object)adNetwork), (String)"adNetwork");
                        Logger.INSTANCE.info("Received bid response and loading creative .... " + this.$placementId + ". winner network: " + (Object)((Object)adNetwork));
                        AdNetworkAdapterProvider adNetworkAdapterProvider = MSPManager.INSTANCE.getAdNetworkAdapterProvider();
                        this.this$0.setAdNetworkAdapter(adNetworkAdapterProvider != null ? adNetworkAdapterProvider.getAdNetworkAdapter(adNetwork) : null);
                        AdNetworkAdapter adNetworkAdapter = this.this$0.getAdNetworkAdapter();
                        if (adNetworkAdapter != null) {
                            adNetworkAdapter.loadAdCreative(bidResponse, this.$adListener, this.$context, this.$adRequest);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        if (unit != null) break block2;
                        BidListenerImp bidListenerImp = this;
                        AdListener adListener = this.$adListener;
                        BidListenerImp $this$onBidResponse_u24lambda_u240 = bidListenerImp;
                        boolean bl = false;
                        adListener.onError("adNetwork Adapter is null for network: " + (Object)((Object)adNetwork));
                        Logger.INSTANCE.info("adNetwork Adapter is null for network: " + (Object)((Object)adNetwork));
                    }
                }

                public void onError(@NotNull String msg) {
                    Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                    this.$adListener.onError("bid error: " + msg);
                    Logger.INSTANCE.info("bid error: " + msg);
                }
            }
            bidLoader.loadBid(placementId, MapsKt.emptyMap(), new BidListenerImp(placementId, this, adListener, context, adRequest), adRequest);
        }
        Logger.INSTANCE.info("loadAd() time latency: " + (System.currentTimeMillis() - start) + " ms");
    }
}

