/*
 * Decompiled with CFR 0.152.
 */
package com.particles.msp.util;

import android.util.Log;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006J\u0016\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006J\u001e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0004J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u000e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006J\u0016\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006J \u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u000e\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0004J\u000e\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006J\u0016\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006J\u0016\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006J\u0016\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/particles/msp/util/Logger;", "", "()V", "ASSERT", "", "BASE_TAG", "", "DEBUG", "ERROR", "INFO", "NONE", "VERBOSE", "WARN", "logLevel", "debug", "", "message", "tag", "msg", "error", "throwable", "", "getLogLevel", "getTagWithBase", "info", "print", "messagePriority", "setLogLevel", "level", "verbose", "warning", "wtf", "msp-core_release"})
public final class Logger {
    @NotNull
    public static final Logger INSTANCE = new Logger();
    @NotNull
    private static final String BASE_TAG = "MSPMobile";
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int ASSERT = 7;
    public static final int NONE = Integer.MAX_VALUE;
    private static int logLevel = Integer.MAX_VALUE;

    private Logger() {
    }

    public final void setLogLevel(int level) {
        logLevel = level;
    }

    public final int getLogLevel() {
        return logLevel;
    }

    public final void verbose(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.verbose(BASE_TAG, message);
    }

    public final void debug(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.debug(BASE_TAG, message);
    }

    public final void info(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.info(BASE_TAG, message);
    }

    public final void warning(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.warning(BASE_TAG, message);
    }

    public final void error(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.error(BASE_TAG, message);
    }

    public final void verbose(@NotNull String tag, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.print(2, tag, msg);
    }

    public final void debug(@NotNull String tag, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.print(3, tag, msg);
    }

    public final void info(@NotNull String tag, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.print(4, tag, msg);
    }

    public final void warning(@NotNull String tag, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.print(5, tag, msg);
    }

    public final void error(@NotNull String tag, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.print(6, tag, msg);
    }

    public final void wtf(@NotNull String tag, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.print(7, tag, msg);
    }

    public final void error(@NotNull String tag, @NotNull String message, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        if (6 >= this.getLogLevel()) {
            this.print(6, this.getTagWithBase(tag), message + ". stack trace: " + ExceptionsKt.stackTraceToString((Throwable)throwable));
        }
    }

    private final void print(int messagePriority, String tag, String message) {
        if (messagePriority >= this.getLogLevel()) {
            Log.println((int)messagePriority, (String)this.getTagWithBase(tag), (String)message);
        }
    }

    private final String getTagWithBase(String tag) {
        String string;
        StringBuilder result = new StringBuilder();
        String prefix = "NBAds";
        if (StringsKt.startsWith$default((String)tag, (String)prefix, (boolean)false, (int)2, null)) {
            result.append(tag);
        } else {
            result.append(prefix).append(tag);
        }
        if (result.length() > 23) {
            String string2 = result.substring(0, 22);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            String string3 = result.toString();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        }
        return string;
    }
}

