package com.particles.msp.api

import com.particles.msp.AdCache
import com.particles.msp.BidListener
import com.particles.msp.BidLoader
import com.particles.msp.MSPManager
import com.particles.msp.adapter.AdNetwork
import com.particles.msp.adapter.AdNetworkAdapter
import com.particles.msp.util.Logger

class AdLoader {
    var bidLoader: BidLoader? = null
    var adNetworkAdapter: AdNetworkAdapter? = null

    fun loadAd(placementId: String, adListener: AdListener, context: Any, adRequest: AdRequest) {
        val start = System.currentTimeMillis()

        if (adRequest.isCacheSupported) {
            val cachedAd: MSPAd? = AdCache.peakAd(placementId)
            cachedAd?.let {
                adListener.onAdLoaded(adRequest.placementId)
                return
            }
            Logger.info("loadAd() time latency: ${System.currentTimeMillis() - start} ms")
        }

        class BidListenerImp : BidListener {
            override fun onBidResponse(bidResponse: Any, adNetwork: AdNetwork) {
                Logger.info("Received bid response and loading creative .... $placementId. winner network: $adNetwork")
                adNetworkAdapter = MSPManager.adNetworkAdapterProvider?.getAdNetworkAdapter(adNetwork)
                adNetworkAdapter?.loadAdCreative(bidResponse, adListener, context, adRequest) ?: run {
                    adListener.onError("adNetwork Adapter is null for network: $adNetwork")
                    Logger.info("adNetwork Adapter is null for network: $adNetwork")
                }
            }

            override fun onError(msg: String) {
                adListener.onError("bid error: $msg")
                Logger.info("bid error: $msg")
            }
        }
        bidLoader = MSPManager.bidLoaderProvider?.getBidLoader()
        Logger.info("Sending bid request.... $placementId")
        bidLoader?.loadBid(placementId, mapOf(), BidListenerImp(), adRequest)
        Logger.info("loadAd() time latency: ${System.currentTimeMillis() - start} ms")
    }
}
