package com.particles.msp.util

import android.util.Log

object Logger {
    private const val BASE_TAG = "MSPMobile"

    const val VERBOSE = 2
    const val DEBUG = 3
    const val INFO = 4
    const val WARN = 5
    const val ERROR = 6
    const val ASSERT = 7
    const val NONE = Int.MAX_VALUE

    private var logLevel: Int = NONE

    fun setLogLevel(level: Int) {
        logLevel = level
    }

    fun getLogLevel(): Int {
        return logLevel
    }

    fun verbose(message: String) {
        verbose(BASE_TAG, message)
    }

    fun debug(message: String) {
        debug(BASE_TAG, message)
    }

    fun info(message: String) {
        info(BASE_TAG, message)
    }

    fun warning(message: String) {
        warning(BASE_TAG, message)
    }

    fun error(message: String) {
        error(BASE_TAG, message)
    }

    fun verbose(tag: String, msg: String) {
        print(VERBOSE, tag, msg)
    }

    fun debug(tag: String, msg: String) {
        print(DEBUG, tag, msg)
    }

    fun info(tag: String, msg: String) {
        print(INFO, tag, msg)
    }

    fun warning(tag: String, msg: String) {
        print(WARN, tag, msg)
    }

    fun error(tag: String, msg: String) {
        print(ERROR, tag, msg)
    }

    fun wtf(tag: String, msg: String) {
        print(ASSERT, tag, msg)
    }

    fun error(tag: String, message: String, throwable: Throwable) {
        if (ERROR >= getLogLevel()) {
            print(ERROR, getTagWithBase(tag), "$message. stack trace: ${throwable.stackTraceToString()}")
        }
    }

    private fun print(messagePriority: Int, tag: String, message: String) {
        if (messagePriority >= getLogLevel()) {
            Log.println(messagePriority, getTagWithBase(tag), message)
        }
    }

    private fun getTagWithBase(tag: String): String {
        val result = StringBuilder()

        val prefix = "NBAds"
        if (tag.startsWith(prefix)) {
            result.append(tag)
        } else {
            result.append(prefix).append(tag)
        }

        return if (result.length > 23) result.substring(0, 22) else result.toString()
    }
}
