package com.particles.msp

import com.particles.msp.api.MSPAd

object AdCache {
    private val adCache: MutableMap<String, MSPAd> = mutableMapOf()

    fun peakAd(placementId: String): MSPAd?  =
        adCache[placementId]?.takeUnless { ad ->
            ad.isInvalid.also { if (it) adCache.remove(placementId) }
        }

    fun getAd(placementId: String): MSPAd? {
        return adCache.remove(placementId)?.takeUnless { it.isInvalid }
    }

    fun saveAd(placement: String, ad: MSPAd) {
        adCache[placement] = ad
    }
}